/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.umlg.java.metamodel.generated.OJPathNameGEN;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJPathName
extends OJPathNameGEN
implements Comparable<OJPathName> {
    private List<OJPathName> generics = new ArrayList<OJPathName>();

    public OJPathName() {
    }

    public OJPathName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        while (st.hasMoreTokens()) {
            this.addToNames(st.nextToken());
        }
    }

    @Override
    public String getFirst() {
        String result = "";
        if (this.getNames().size() > 0) {
            result = this.getNames().get(0);
        }
        return result;
    }

    @Override
    public String getLast() {
        String result = "";
        if (this.getNames().size() > 0) {
            result = this.getNames().get(this.getNames().size() - 1);
        }
        StringBuilder pathInfo = new StringBuilder();
        if (!this.generics.isEmpty()) {
            boolean first = true;
            pathInfo.append("<");
            for (OJPathName pathName : this.generics) {
                if (first) {
                    first = false;
                } else {
                    pathInfo.append(",");
                }
                pathInfo.append(pathName.getLast());
            }
            pathInfo.append(">");
            result = result + pathInfo.toString();
        }
        return result;
    }

    public OJPathName replaceGeneric(int index, String ojPathName) {
        this.generics.remove(index);
        this.generics.add(index, new OJPathName(ojPathName));
        return this;
    }

    public OJPathName replaceGeneric(int index, OJPathName ojPathName) {
        this.generics.remove(index);
        this.generics.add(index, ojPathName);
        return this;
    }

    @Override
    public OJPathName getHead() {
        OJPathName result = new OJPathName();
        if (this.getNames().size() > 0) {
            result.setNames(this.getNames().subList(0, this.getNames().size() - 1));
        }
        return result;
    }

    @Override
    public OJPathName getTail() {
        OJPathName result = new OJPathName();
        if (this.getNames().size() > 0) {
            result.setNames(this.getNames().subList(1, this.getNames().size()));
        }
        return result;
    }

    public String getTypeName() {
        return this.getLast();
    }

    public String getCollectionTypeName() {
        if (this.getElementTypes().isEmpty()) {
            return this.getLast();
        }
        return this.getLast() + this.elementTypesToJavaString();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof OJPathName && super.equals((OJPathName)other);
    }

    @Override
    public int hashCode() {
        return this.getLast().hashCode();
    }

    @Override
    public String toJavaString() {
        StringBuilder pathInfo = new StringBuilder();
        boolean first = true;
        Iterator<String> it = this.getNames().iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                pathInfo.append(".");
            }
            String elem = it.next();
            pathInfo.append(elem);
        }
        if (!this.generics.isEmpty()) {
            pathInfo.append("<");
            first = true;
            for (OJPathName pathName : this.generics) {
                if (first) {
                    first = false;
                } else {
                    pathInfo.append(",");
                }
                pathInfo.append(pathName.toJavaString());
            }
            pathInfo.append(">");
        }
        return pathInfo.toString();
    }

    private String elementTypesToJavaString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (OJPathName elemType : this.getElementTypes()) {
            if (elemType.getLast().equals("void")) continue;
            if (first) {
                first = false;
                result.append("<");
            } else {
                result.append(", ");
            }
            result.append(elemType.getCollectionTypeName());
        }
        if (result.length() != 0) {
            result.append(">");
        }
        return result.toString();
    }

    @Override
    public String toString() {
        return JavaUtil.collectionToString(this.getNames(), ".");
    }

    @Override
    public OJPathName getCopy() {
        OJPathName result = new OJPathName();
        result.setNames(new ArrayList<String>(this.getNames()));
        result.generics = new ArrayList<OJPathName>(this.getGenerics());
        return result;
    }

    public OJPathName getDeepCopy() {
        OJPathName result = new OJPathName();
        result.setNames(new ArrayList<String>(this.getNames()));
        List<OJPathName> elementTypes = this.getElementTypes();
        for (OJPathName elementType : elementTypes) {
            OJPathName elementTypeCopy = elementType.getDeepCopy();
            if (elementType.getLast().contains("extends")) {
                System.out.println();
            }
            result.addToElementTypes(elementTypeCopy);
        }
        return result;
    }

    @Override
    public boolean isSingleName() {
        return this.getNames().size() == 1;
    }

    public void replaceTail(String newtail) {
        this.getNames().set(this.getNames().size() - 1, newtail);
    }

    public void insertBeforeTail(String name) {
        this.getNames().add(this.getNames().size() - 1, name);
    }

    @Override
    public OJPathName append(String str) {
        this.addToNames(str);
        return this;
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        if (this.getLast().charAt(0) == '?') {
            this.replaceTail(OJPathName.replaceAll(this.getLast(), renamePathNames, newName));
        } else if (renamePathNames.contains(this)) {
            this.replaceTail(this.getLast() + newName);
        }
        for (OJPathName elementType : this.getElementTypes()) {
            elementType.renameAll(renamePathNames, newName);
        }
    }

    @Override
    public int compareTo(OJPathName o) {
        List<String> myNames = this.getNames();
        List<String> otherNames = o.getNames();
        for (int i = 0; i < myNames.size(); ++i) {
            if (otherNames.size() > i) {
                int compareTo = otherNames.get(i).compareTo(myNames.get(i));
                if (compareTo == 0) continue;
                return compareTo;
            }
            return 1;
        }
        if (myNames.size() < otherNames.size()) {
            return -1;
        }
        return 0;
    }

    public void clearGenerics() {
        this.generics.clear();
    }

    public OJPathName addToGenerics(OJPathName path) {
        this.generics.add(path);
        return this;
    }

    public List<OJPathName> getGenerics() {
        ArrayList<OJPathName> copy = new ArrayList<OJPathName>();
        for (OJPathName o : this.generics) {
            copy.add(o.getCopy());
        }
        return copy;
    }

    public OJPathName renameLast(String name) {
        this.removeFromNames(this.getLast());
        this.append(name);
        return this;
    }

    public OJPathName addToGenerics(String string) {
        return this.addToGenerics(new OJPathName(string));
    }

    public OJPathName appendToTail(String s) {
        return this.renameLast(this.getLast() + s);
    }

    public void appendToGeneric(String string) {
        for (OJPathName g : this.generics) {
            g.appendToTail(string);
        }
    }
}

