/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.umlg.java.metamodel.OJOperation;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.OJAnnotatedClass;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;
import org.umlg.java.metamodel.utilities.OJOperationComparator;

public class OJAnnotatedInterface
extends OJAnnotatedClass {
    private Set<OJPathName> superInterfaces = new HashSet<OJPathName>();

    public OJAnnotatedInterface(String string) {
        super(string);
    }

    @Override
    public String toJavaString() {
        this.calcImports();
        StringBuilder classInfo = new StringBuilder();
        classInfo.append(this.getMyPackage().toJavaString());
        classInfo.append("\n");
        classInfo.append((CharSequence)this.imports());
        classInfo.append("\n");
        this.addJavaDocComment(classInfo);
        if (this.getAnnotations().size() > 0) {
            classInfo.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getAnnotations(), "\n"), 0));
            classInfo.append("\n");
        }
        classInfo.append(this.visToJava(this) + " ");
        classInfo.append("interface " + this.getName());
        classInfo.append((CharSequence)this.superInterfaces());
        classInfo.append(" {\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.operations(), 1));
        classInfo.append("\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.innerEnums(), 1));
        classInfo.append("\n");
        classInfo.append("}");
        return classInfo.toString();
    }

    private StringBuilder superInterfaces() {
        StringBuilder result = new StringBuilder();
        if (this.getSuperInterfaces().size() > 0) {
            Iterator<OJPathName> it = this.getSuperInterfaces().iterator();
            boolean first = true;
            while (it.hasNext()) {
                OJPathName elem = it.next();
                if (first) {
                    result.append(" extends ");
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(elem.getLast());
            }
        }
        return result;
    }

    @Override
    public StringBuilder operations() {
        ArrayList<OJOperation> temp = new ArrayList<OJOperation>(this.getOperations());
        Collections.sort(temp, new OJOperationComparator());
        StringBuilder result = new StringBuilder();
        result.append(JavaUtil.collectionToJavaString(temp, "\n"));
        return result;
    }

    public Set<OJPathName> getSuperInterfaces() {
        return this.superInterfaces;
    }

    public void addToSuperInterfaces(OJPathName i) {
        this.superInterfaces.add(i);
    }

    @Override
    public void calcImports() {
        super.calcImports();
        this.addToImports(this.getSuperInterfaces());
    }

    @Override
    public OJAnnotatedInterface getDeepCopy(OJPackage owner) {
        OJAnnotatedInterface copy = new OJAnnotatedInterface(this.getName());
        copy.setMyPackage(owner);
        this.copyDeepInfoInto(copy);
        return copy;
    }

    protected void copyDeepInfoInto(OJAnnotatedInterface copy) {
        super.copyDeepInfoInto(copy);
        for (OJPathName superInterfaze : this.superInterfaces) {
            copy.addToSuperInterfaces(superInterfaze.getDeepCopy());
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        super.renameAll(renamePathNames, newName);
        Set<OJPathName> superInterfaces = this.getSuperInterfaces();
        for (OJPathName ojPathName : superInterfaces) {
            ojPathName.renameAll(renamePathNames, newName);
        }
    }

    public void removeFromSuperInterfaces(OJPathName toRemove) {
        this.superInterfaces.remove(toRemove);
    }
}

