/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.umlg.java.metamodel.OJParameter;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.AnnotationHelper;
import org.umlg.java.metamodel.annotation.OJAnnotatedElement;
import org.umlg.java.metamodel.annotation.OJAnnotationValue;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJAnnotatedParameter
extends OJParameter
implements OJAnnotatedElement {
    Map<OJPathName, OJAnnotationValue> f_annotations = new TreeMap<OJPathName, OJAnnotationValue>();

    public OJAnnotatedParameter(String string, OJPathName ojPathName) {
        this.setName(string);
        this.setType(ojPathName);
    }

    public OJAnnotatedParameter() {
    }

    @Override
    public Collection<OJAnnotationValue> getAnnotations() {
        return this.f_annotations.values();
    }

    @Override
    public boolean addAnnotationIfNew(OJAnnotationValue value) {
        if (this.f_annotations.containsKey(value.getType())) {
            return false;
        }
        this.putAnnotation(value);
        return true;
    }

    @Override
    public OJAnnotationValue putAnnotation(OJAnnotationValue value) {
        return this.f_annotations.put(value.getType(), value);
    }

    @Override
    public OJAnnotationValue removeAnnotation(OJPathName type) {
        return this.f_annotations.remove(type);
    }

    @Override
    public String toJavaString() {
        StringBuilder sb = new StringBuilder();
        if (!this.getComment().equals("")) {
            sb.append("\t// ");
            sb.append(this.getComment());
            sb.append("\n");
        }
        if (this.isFinal) {
            sb.append("final ");
        }
        if (this.getAnnotations().size() > 0) {
            sb.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getAnnotations(), " "), 0));
        }
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getType().getCollectionTypeName());
        sb.append(' ');
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public OJAnnotatedParameter getDeepCopy() {
        OJAnnotatedParameter copy = new OJAnnotatedParameter();
        this.copyDeepInfoInto(copy);
        return copy;
    }

    public void copyDeepInfoInto(OJAnnotatedParameter copy) {
        super.copyDeepInfoInto(copy);
        Collection<OJAnnotationValue> annotations = this.getAnnotations();
        for (OJAnnotationValue ojAnnotationValue : annotations) {
            OJAnnotationValue copyAnnotation = ojAnnotationValue.getDeepCopy();
            copy.addAnnotationIfNew(copyAnnotation);
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String newName) {
        super.renameAll(renamePathNames, newName);
        Collection<OJAnnotationValue> annotations = this.getAnnotations();
        for (OJAnnotationValue ojAnnotationValue : annotations) {
            Set<OJPathName> usedTypes = ojAnnotationValue.getAllTypesUsed();
            for (OJPathName usedType : usedTypes) {
                usedType.renameAll(renamePathNames, newName);
            }
        }
    }

    @Override
    public OJAnnotationValue findAnnotation(OJPathName path) {
        return AnnotationHelper.getAnnotation(this, path);
    }
}

