/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.umlg.java.metamodel.OJElement;
import org.umlg.java.metamodel.OJField;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.AnnotationHelper;
import org.umlg.java.metamodel.annotation.OJAnnotatedElement;
import org.umlg.java.metamodel.annotation.OJAnnotationValue;

public class OJEnumLiteral
extends OJElement
implements OJAnnotatedElement {
    List<OJField> attributeValues = new ArrayList<OJField>();
    Map<OJPathName, OJAnnotationValue> f_annotations = new TreeMap<OJPathName, OJAnnotationValue>();

    public OJEnumLiteral(String name) {
        super.setName(name);
    }

    public OJEnumLiteral() {
    }

    @Override
    public String toJavaString() {
        if (this.attributeValues.isEmpty()) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append('(');
        Iterator<OJField> iter = this.attributeValues.iterator();
        while (iter.hasNext()) {
            OJField a = iter.next();
            sb.append("/* " + a.getName() + " */ ");
            sb.append(a.getInitExp());
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public void addToAttributeValues(OJField field) {
        this.attributeValues.add(field);
    }

    public OJField findAttributeValue(String fieldName) {
        for (OJField f : this.attributeValues) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        OJField value = new OJField();
        value.setName(fieldName);
        this.attributeValues.add(value);
        return value;
    }

    @Override
    public OJAnnotationValue findAnnotation(OJPathName path) {
        return AnnotationHelper.getAnnotation(this, path);
    }

    @Override
    public boolean addAnnotationIfNew(OJAnnotationValue value) {
        if (this.f_annotations.containsKey(value.getType())) {
            return false;
        }
        this.putAnnotation(value);
        return true;
    }

    @Override
    public Collection<OJAnnotationValue> getAnnotations() {
        return this.f_annotations.values();
    }

    @Override
    public OJAnnotationValue putAnnotation(OJAnnotationValue value) {
        return this.f_annotations.put(value.getType(), value);
    }

    @Override
    public OJAnnotationValue removeAnnotation(OJPathName type) {
        return this.f_annotations.remove(type);
    }

    @Override
    public void renameAll(Set<OJPathName> match, String suffix) {
        for (OJAnnotationValue a : this.getAnnotations()) {
            a.renameAll(match, suffix);
        }
        for (OJField ojField : this.attributeValues) {
            ojField.setInitExp(OJEnumLiteral.replaceAll(ojField.getInitExp(), match, suffix));
        }
    }
}

