/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vafer.jdependency.ClazzpathUnit;

public final class Clazz
implements Comparable<Clazz> {
    private final Set<Clazz> dependencies = new HashSet<Clazz>();
    private final Set<Clazz> references = new HashSet<Clazz>();
    private final Map<ClazzpathUnit, String> units = new HashMap<ClazzpathUnit, String>();
    private final String name;

    public Clazz(String pName) {
        this.name = pName;
    }

    public String getName() {
        return this.name;
    }

    public void addClazzpathUnit(ClazzpathUnit pUnit, String pDigest) {
        this.units.put(pUnit, pDigest);
    }

    public void removeClazzpathUnit(ClazzpathUnit pUnit) {
        this.units.remove(pUnit);
    }

    public Set<ClazzpathUnit> getClazzpathUnits() {
        return this.units.keySet();
    }

    public Set<String> getVersions() {
        return new HashSet<String>(this.units.values());
    }

    public void addDependency(Clazz pClazz) {
        pClazz.references.add(this);
        this.dependencies.add(pClazz);
    }

    public void removeDependency(Clazz pClazz) {
        pClazz.references.remove(this);
        this.dependencies.remove(pClazz);
    }

    public Set<Clazz> getDependencies() {
        return this.dependencies;
    }

    public Set<Clazz> getReferences() {
        return this.references;
    }

    public Set<Clazz> getTransitiveDependencies() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        this.findTransitiveDependencies(all);
        return all;
    }

    void findTransitiveDependencies(Set<? super Clazz> pAll) {
        for (Clazz clazz : this.dependencies) {
            if (pAll.contains(clazz)) continue;
            pAll.add(clazz);
            clazz.findTransitiveDependencies(pAll);
        }
    }

    public boolean equals(Object pO) {
        if (pO.getClass() != Clazz.class) {
            return false;
        }
        Clazz c = (Clazz)pO;
        return this.name.equals(c.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Clazz pO) {
        return this.name.compareTo(pO.name);
    }

    public String toString() {
        return this.name;
    }
}

