/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi;

import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.visallo.web.clientapi.ApiInvoker;
import org.visallo.web.clientapi.VisalloApi;
import org.visallo.web.clientapi.VisalloClientApiException;
import org.visallo.web.clientapi.model.ClientApiWorkspace;

public abstract class FormLoginVisalloApi
extends VisalloApi {
    abstract String getLoginFormBody();

    public FormLoginVisalloApi(String basePath) {
        this(basePath, false);
    }

    public FormLoginVisalloApi(String basePath, boolean ignoreSslErrors) {
        super(basePath);
        if (ignoreSslErrors) {
            try {
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession sslSession) {
                        return true;
                    }
                });
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception ex) {
                throw new VisalloClientApiException("Could not ignore SSL errors", ex);
            }
        }
    }

    protected ClientApiWorkspace logIn() {
        try {
            URL url = new URL(this.getBasePath() + "/login");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes(this.getLoginFormBody());
            out.flush();
            out.close();
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new VisalloClientApiException("Invalid response code. Expected 200. Found " + code);
            }
            Map<String, List<String>> responseHeaders = conn.getHeaderFields();
            List<String> cookies = responseHeaders.get("Set-Cookie");
            if (cookies == null) {
                throw new VisalloClientApiException("Could not find cookie header in response");
            }
            for (String cookie : cookies) {
                if (!cookie.startsWith("JSESSIONID=")) continue;
                String cookieValue = cookie.substring("JSESSIONID=".length());
                int sep = cookieValue.indexOf(59);
                if (sep > 0) {
                    cookieValue = cookieValue.substring(0, sep);
                }
                ApiInvoker.getInstance().setJSessionId(cookieValue);
                return this.loginAndGetCurrentWorkspace();
            }
            throw new VisalloClientApiException("Could not find JSESSIONID cookie");
        }
        catch (Exception e) {
            throw new VisalloClientApiException("Could not login: " + this.getBasePath(), e);
        }
    }
}

