/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.visallo.web.clientapi.AdminApiExt;
import org.visallo.web.clientapi.ApiInvoker;
import org.visallo.web.clientapi.EdgeApiExt;
import org.visallo.web.clientapi.LongRunningProcessApiExt;
import org.visallo.web.clientapi.OntologyApiExt;
import org.visallo.web.clientapi.UserApiExt;
import org.visallo.web.clientapi.VertexApiExt;
import org.visallo.web.clientapi.WorkspaceApiExt;
import org.visallo.web.clientapi.codegen.ApiException;
import org.visallo.web.clientapi.model.ClientApiUser;
import org.visallo.web.clientapi.model.ClientApiWorkspace;

public class VisalloApi {
    private final UserApiExt userApi;
    private final WorkspaceApiExt workspaceApi;
    private final AdminApiExt adminApi;
    private final VertexApiExt vertexApi;
    private final OntologyApiExt ontologyApi;
    private final EdgeApiExt edgeApi;
    private final LongRunningProcessApiExt longRunningProcessApi;
    private final String basePath;
    private ClientApiUser me;

    public VisalloApi(String basePath) {
        this.basePath = this.cleanBasePath(basePath);
        this.userApi = new UserApiExt();
        this.userApi.setBasePath(this.basePath);
        this.workspaceApi = new WorkspaceApiExt();
        this.workspaceApi.setBasePath(this.basePath);
        this.adminApi = new AdminApiExt();
        this.adminApi.setBasePath(this.basePath);
        this.vertexApi = new VertexApiExt();
        this.vertexApi.setBasePath(this.basePath);
        this.edgeApi = new EdgeApiExt();
        this.edgeApi.setBasePath(this.basePath);
        this.ontologyApi = new OntologyApiExt();
        this.ontologyApi.setBasePath(this.basePath);
        this.longRunningProcessApi = new LongRunningProcessApiExt();
        this.longRunningProcessApi.setBasePath(this.basePath);
    }

    private String cleanBasePath(String basePath) {
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    public UserApiExt getUserApi() {
        return this.userApi;
    }

    public WorkspaceApiExt getWorkspaceApi() {
        return this.workspaceApi;
    }

    public AdminApiExt getAdminApi() {
        return this.adminApi;
    }

    public VertexApiExt getVertexApi() {
        return this.vertexApi;
    }

    public OntologyApiExt getOntologyApi() {
        return this.ontologyApi;
    }

    public EdgeApiExt getEdgeApi() {
        return this.edgeApi;
    }

    public LongRunningProcessApiExt getLongRunningProcessApi() {
        return this.longRunningProcessApi;
    }

    public String getCurrentWorkspaceId() {
        return ApiInvoker.getInstance().getWorkspaceId();
    }

    public ClientApiWorkspace loginAndGetCurrentWorkspace() throws ApiException {
        this.me = this.getUserApi().getMe();
        ApiInvoker.getInstance().setCsrfToken(this.me.getCsrfToken());
        List<ClientApiWorkspace> workspaces = this.getWorkspaceApi().getAll().getWorkspaces();
        ClientApiWorkspace currentWorkspace = null;
        if (this.me.getCurrentWorkspaceId() != null) {
            for (ClientApiWorkspace workspace : workspaces) {
                if (!workspace.getWorkspaceId().equals(this.me.getCurrentWorkspaceId())) continue;
                currentWorkspace = workspace;
                break;
            }
        }
        if (currentWorkspace == null) {
            currentWorkspace = workspaces.size() == 0 ? this.getWorkspaceApi().create() : workspaces.get(0);
        }
        ApiInvoker.getInstance().setWorkspaceId(currentWorkspace.getWorkspaceId());
        return currentWorkspace;
    }

    public String invokeAPI(String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, Map<String, String> formParams, String contentType) throws ApiException {
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        if (headerParams == null) {
            headerParams = new HashMap<String, String>();
        }
        if (formParams == null) {
            formParams = new HashMap<String, String>();
        }
        return ApiInvoker.getInstance().invokeAPI(this.basePath, path, method, queryParams, body, headerParams, formParams, contentType);
    }

    public void logout() throws ApiException {
        this.invokeAPI("/logout", "POST", null, null, null, null, null);
    }

    public String getCurrentUserId() {
        return this.me.getId();
    }

    public void setWorkspaceId(String workspaceId) {
        ApiInvoker.getInstance().setWorkspaceId(workspaceId);
    }

    public String getBasePath() {
        return this.basePath;
    }
}

