/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.visallo.web.clientapi.model.ClientApiEdge;
import org.visallo.web.clientapi.model.ClientApiEdgeSearchResponse;
import org.visallo.web.clientapi.model.ClientApiElementSearchResponse;
import org.visallo.web.clientapi.model.ClientApiGeoPoint;
import org.visallo.web.clientapi.model.ClientApiGeoRect;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.ClientApiScalarSearchResponse;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.clientapi.util.ClientApiConverter;

public abstract class ClientApiSearchResponse
implements ClientApiObject {
    private Integer nextOffset = null;
    private Long retrievalTime = null;
    private Long totalTime = null;
    private Long totalHits = null;
    private Long searchTime = null;
    private Map<String, AggregateResult> aggregates = new HashMap<String, AggregateResult>();

    public Integer getNextOffset() {
        return this.nextOffset;
    }

    public void setNextOffset(Integer nextOffset) {
        this.nextOffset = nextOffset;
    }

    public Long getRetrievalTime() {
        return this.retrievalTime;
    }

    public void setRetrievalTime(Long retrievalTime) {
        this.retrievalTime = retrievalTime;
    }

    public Long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(Long totalTime) {
        this.totalTime = totalTime;
    }

    public Long getTotalHits() {
        return this.totalHits;
    }

    public void setTotalHits(Long totalHits) {
        this.totalHits = totalHits;
    }

    public Long getSearchTime() {
        return this.searchTime;
    }

    public void setSearchTime(Long searchTime) {
        this.searchTime = searchTime;
    }

    public String toString() {
        return ClientApiConverter.clientApiToString(this);
    }

    public abstract int getItemCount();

    public Map<String, AggregateResult> getAggregates() {
        return this.aggregates;
    }

    public static ClientApiSearchResponse listToClientApiSearchResponse(List<List<Object>> rows) {
        ClientApiSearchResponse results;
        if (rows == null || rows.size() == 0) {
            results = new ClientApiElementSearchResponse();
        } else if (rows.get(0).size() == 1 && rows.get(0).get(0) instanceof ClientApiVertex) {
            results = new ClientApiElementSearchResponse();
            ((ClientApiElementSearchResponse)results).getElements().addAll(ClientApiSearchResponse.toClientApiVertex(rows));
        } else if (rows.get(0).size() == 1 && rows.get(0).get(0) instanceof ClientApiEdge) {
            results = new ClientApiEdgeSearchResponse();
            ((ClientApiEdgeSearchResponse)results).getResults().addAll(ClientApiSearchResponse.toClientApiEdge(rows));
        } else {
            results = new ClientApiScalarSearchResponse();
            ((ClientApiScalarSearchResponse)results).getResults().addAll(rows);
        }
        return results;
    }

    private static Collection<ClientApiVertex> toClientApiVertex(List<List<Object>> rows) {
        ArrayList<ClientApiVertex> results = new ArrayList<ClientApiVertex>();
        for (List<Object> row : rows) {
            results.add((ClientApiVertex)row.get(0));
        }
        return results;
    }

    private static Collection<ClientApiEdge> toClientApiEdge(List<List<Object>> rows) {
        ArrayList<ClientApiEdge> results = new ArrayList<ClientApiEdge>();
        for (List<Object> row : rows) {
            results.add((ClientApiEdge)row.get(0));
        }
        return results;
    }

    public static class StatisticsAggregateResult
    extends AggregateResult {
        private long count;
        private double average;
        private double min;
        private double max;
        private double standardDeviation;
        private double sum;

        public void setCount(long count) {
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        public void setAverage(double average) {
            this.average = average;
        }

        public double getAverage() {
            return this.average;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public double getMin() {
            return this.min;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public double getMax() {
            return this.max;
        }

        public void setStandardDeviation(double standardDeviation) {
            this.standardDeviation = standardDeviation;
        }

        public double getStandardDeviation() {
            return this.standardDeviation;
        }

        public void setSum(double sum) {
            this.sum = sum;
        }

        public double getSum() {
            return this.sum;
        }
    }

    public static class HistogramAggregateResult
    extends AggregateResult {
        private Map<String, Bucket> buckets = new HashMap<String, Bucket>();

        public Map<String, Bucket> getBuckets() {
            return this.buckets;
        }

        public static class Bucket
        extends AggregateResult.BucketBase {
            private final long count;

            public Bucket(long count, Map<String, AggregateResult> nestedResults) {
                super(nestedResults);
                this.count = count;
            }

            public long getCount() {
                return this.count;
            }
        }
    }

    public static class GeohashAggregateResult
    extends AggregateResult {
        private long maxCount;
        private Map<String, Bucket> buckets = new HashMap<String, Bucket>();

        public void setMaxCount(long maxCount) {
            this.maxCount = maxCount;
        }

        public long getMaxCount() {
            return this.maxCount;
        }

        public Map<String, Bucket> getBuckets() {
            return this.buckets;
        }

        public static class Bucket
        extends AggregateResult.BucketBase {
            private final ClientApiGeoRect cell;
            private final ClientApiGeoPoint point;
            private final long count;

            public Bucket(ClientApiGeoRect cell, ClientApiGeoPoint point, long count, Map<String, AggregateResult> nestedResults) {
                super(nestedResults);
                this.cell = cell;
                this.point = point;
                this.count = count;
            }

            public ClientApiGeoRect getCell() {
                return this.cell;
            }

            public ClientApiGeoPoint getPoint() {
                return this.point;
            }

            public long getCount() {
                return this.count;
            }
        }
    }

    public static class TermsAggregateResult
    extends AggregateResult {
        private Map<String, Bucket> buckets = new HashMap<String, Bucket>();

        public Map<String, Bucket> getBuckets() {
            return this.buckets;
        }

        public static class Bucket
        extends AggregateResult.BucketBase {
            private final long count;

            public Bucket(long count, Map<String, AggregateResult> nestedResults) {
                super(nestedResults);
                this.count = count;
            }

            public long getCount() {
                return this.count;
            }
        }
    }

    public static abstract class AggregateResult {

        public static abstract class BucketBase {
            private final Map<String, AggregateResult> nestedResults;

            protected BucketBase(Map<String, AggregateResult> nestedResults) {
                this.nestedResults = nestedResults;
            }

            public Map<String, AggregateResult> getNestedResults() {
                return this.nestedResults;
            }
        }
    }
}

