/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.visallo.web.clientapi.VisalloClientApiException;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.DirectoryGroup;
import org.visallo.web.clientapi.model.DirectoryPerson;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DirectoryGroup.class, name="group"), @JsonSubTypes.Type(value=DirectoryPerson.class, name="person")})
public abstract class DirectoryEntity
implements ClientApiObject,
Comparable<DirectoryEntity> {
    public static final String TYPE_GROUP = "group";
    public static final String TYPE_PERSON = "person";
    private final String id;
    private final String displayName;

    public DirectoryEntity(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract String getType();

    public static DirectoryEntity fromMap(Map map) {
        String type = (String)map.get("type");
        String id = (String)map.get("id");
        String displayName = (String)map.get("displayName");
        if (TYPE_GROUP.equalsIgnoreCase(type)) {
            return new DirectoryGroup(id, displayName);
        }
        if (TYPE_PERSON.equalsIgnoreCase(type)) {
            return new DirectoryPerson(id, displayName);
        }
        throw new VisalloClientApiException("Unhandled type: " + type);
    }

    public static boolean isEntity(Map map) {
        String id = (String)map.get("id");
        String displayName = (String)map.get("displayName");
        String type = (String)map.get("type");
        return type != null && id != null && displayName != null && DirectoryEntity.isType(type);
    }

    private static boolean isType(String type) {
        return type.equalsIgnoreCase(TYPE_GROUP) || type.equalsIgnoreCase(TYPE_PERSON);
    }

    @Override
    public int compareTo(DirectoryEntity o) {
        int i = this.getType().compareTo(o.getType());
        if (i != 0) {
            return i;
        }
        return this.getId().compareTo(o.getId());
    }
}

