/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.visallo.web.clientapi.util.StringUtils;

public final class Privilege {
    public static final String READ = "READ";
    public static final String COMMENT = "COMMENT";
    public static final String COMMENT_EDIT_ANY = "COMMENT_EDIT_ANY";
    public static final String COMMENT_DELETE_ANY = "COMMENT_DELETE_ANY";
    public static final String SEARCH_SAVE_GLOBAL = "SEARCH_SAVE_GLOBAL";
    public static final String EDIT = "EDIT";
    public static final String PUBLISH = "PUBLISH";
    public static final String ADMIN = "ADMIN";
    public static final Set<Privilege> ALL_BUILT_IN;
    private final String name;

    public Privilege(String name) {
        this.name = name;
    }

    public static Set<String> newSet(String ... privileges) {
        HashSet set = new HashSet();
        Collections.addAll(set, privileges);
        return Collections.unmodifiableSet(set);
    }

    private static List<String> sortPrivileges(Iterable<String> privileges) {
        ArrayList<String> sortedPrivileges = new ArrayList<String>();
        for (String privilege : privileges) {
            sortedPrivileges.add(privilege);
        }
        Collections.sort(sortedPrivileges);
        return sortedPrivileges;
    }

    public static JSONArray toJson(Set<String> privileges) {
        JSONArray json = new JSONArray();
        for (String privilege : Privilege.sortPrivileges(privileges)) {
            json.put(privilege);
        }
        return json;
    }

    public static Set<String> stringToPrivileges(String privilegesString) {
        if (privilegesString == null || privilegesString.equalsIgnoreCase("NONE")) {
            return Collections.emptySet();
        }
        String[] privilegesStringParts = privilegesString.split(",");
        HashSet<String> privileges = new HashSet<String>();
        for (String privilegesStringPart : privilegesStringParts) {
            if (privilegesStringPart.trim().length() == 0) continue;
            privileges.add(privilegesStringPart.trim());
        }
        return privileges;
    }

    public static String toString(Iterable<String> privileges) {
        return StringUtils.join(Privilege.sortPrivileges(privileges));
    }

    public static String toStringPrivileges(Iterable<Privilege> privileges) {
        ArrayList<String> privilegeStrings = new ArrayList<String>();
        for (Privilege privilege : privileges) {
            privilegeStrings.add(privilege.getName());
        }
        return Privilege.toString(privilegeStrings);
    }

    public static boolean hasAll(Set<String> userPrivileges, Set<String> requiredPrivileges) {
        for (String privilege : requiredPrivileges) {
            if (userPrivileges.contains(privilege)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    static {
        String[] allNames = new String[]{READ, COMMENT, COMMENT_EDIT_ANY, COMMENT_DELETE_ANY, SEARCH_SAVE_GLOBAL, EDIT, PUBLISH, ADMIN};
        HashSet<Privilege> allPrivileges = new HashSet<Privilege>(allNames.length);
        for (String name : allNames) {
            allPrivileges.add(new Privilege(name));
        }
        ALL_BUILT_IN = Collections.unmodifiableSet(allPrivileges);
    }
}

