/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.visallo.web.clientapi.util.ClientApiConverter;

public class VisibilityJson {
    private String source = "";
    private Set<String> workspaces = new HashSet<String>();

    public VisibilityJson() {
    }

    public VisibilityJson(String source) {
        if (source == null) {
            source = "";
        }
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Set<String> getWorkspaces() {
        return this.workspaces;
    }

    public void addWorkspace(String workspaceId) {
        if (workspaceId != null) {
            this.workspaces.add(workspaceId);
        }
    }

    public String toString() {
        return ClientApiConverter.clientApiToString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisibilityJson that = (VisibilityJson)o;
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.workspaces != null ? !this.workspaces.equals(that.workspaces) : that.workspaces != null);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public static VisibilityJson removeFromWorkspace(VisibilityJson json, String workspaceId) {
        if (json == null) {
            json = new VisibilityJson();
        }
        json.getWorkspaces().remove(workspaceId);
        return json;
    }

    public static VisibilityJson removeFromAllWorkspace(VisibilityJson json) {
        if (json == null) {
            json = new VisibilityJson();
        }
        json.getWorkspaces().clear();
        return json;
    }

    public static VisibilityJson updateVisibilitySourceAndAddWorkspaceId(VisibilityJson visibilityJson, String visibilitySource, String workspaceId) {
        if (visibilityJson == null) {
            visibilityJson = new VisibilityJson();
        }
        visibilityJson.setSource(visibilitySource);
        visibilityJson.addWorkspace(workspaceId);
        return visibilityJson;
    }

    public static VisibilityJson updateVisibilitySource(VisibilityJson visibilityJson, String visibilitySource) {
        if (visibilityJson == null) {
            visibilityJson = new VisibilityJson();
        }
        visibilityJson.setSource(visibilitySource);
        return visibilityJson;
    }

    public static boolean isVisibilityJson(Map map) {
        return map.size() == 2 && map.containsKey("source") && map.containsKey("workspaces");
    }

    public static VisibilityJson fromMap(Map map) {
        VisibilityJson visibilityJson = new VisibilityJson();
        visibilityJson.setSource((String)map.get("source"));
        List workspaces = (List)map.get("workspaces");
        for (String workspace : workspaces) {
            visibilityJson.addWorkspace(workspace);
        }
        return visibilityJson;
    }
}

