/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.interceptor.JavaScriptProtocol;
import org.json.JSONObject;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.user.UserSessionCounterRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.status.JmxMetricsManager;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.CurrentUser;
import org.visallo.web.clientapi.model.UserStatus;

@AtmosphereHandlerService(path="/messaging", broadcasterCache=UUIDBroadcasterCache.class, interceptors={AtmosphereResourceLifecycleInterceptor.class, BroadcastOnPostAtmosphereInterceptor.class, TrackMessageSizeInterceptor.class, HeartbeatInterceptor.class, JavaScriptProtocol.class})
public class Messaging
implements AtmosphereHandler {
    public static final String PATH = "/messaging";
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(Messaging.class);
    private UserRepository userRepository;
    private static Broadcaster broadcaster;
    private WorkspaceRepository workspaceRepository;
    private WorkQueueRepository workQueueRepository;
    private UserSessionCounterRepository userSessionCounterRepository;
    private boolean subscribedToBroadcast = false;
    private Map<AtmosphereResource.TRANSPORT, Counter> requestsCounters = new HashMap<AtmosphereResource.TRANSPORT, Counter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequest(AtmosphereResource resource) throws IOException {
        this.ensureInitialized(resource);
        CurrentUser.setUserInLogMappedDiagnosticContexts((HttpServletRequest)resource.getRequest());
        try {
            Counter requestsCounter = this.requestsCounters.get(resource.transport());
            if (requestsCounter == null) {
                LOGGER.error("unexpected transport: " + resource.transport(), new Object[0]);
            } else {
                requestsCounter.inc();
            }
            AtmosphereRequest request = resource.getRequest();
            BufferedReader reader = request.getReader();
            String requestData = IOUtils.toString((Reader)reader);
            try {
                if (!StringUtils.isBlank((String)requestData)) {
                    this.processRequestData(resource, requestData);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Could not handle async message: " + requestData, (Throwable)ex);
            }
            if (request.getMethod().equalsIgnoreCase("GET")) {
                this.onOpen(resource);
                resource.suspend();
            } else if (request.getMethod().equalsIgnoreCase("POST")) {
                LOGGER.debug("onRequest() POST: %s", new Object[]{requestData});
                resource.getBroadcaster().broadcast((Object)requestData);
            }
        }
        finally {
            CurrentUser.clearUserFromLogMappedDiagnosticContexts();
        }
    }

    private void ensureInitialized(AtmosphereResource resource) {
        if (this.userRepository == null) {
            Injector injector = (Injector)resource.getAtmosphereConfig().getServletContext().getAttribute(Injector.class.getName());
            injector.injectMembers((Object)this);
        }
        if (!this.subscribedToBroadcast) {
            this.workQueueRepository.subscribeToBroadcastMessages(new WorkQueueRepository.BroadcastConsumer(){

                public void broadcastReceived(JSONObject json) {
                    if (broadcaster != null) {
                        broadcaster.broadcast((Object)json.toString());
                    }
                }
            });
            this.subscribedToBroadcast = true;
        }
        broadcaster = resource.getBroadcaster();
    }

    public void destroy() {
        LOGGER.debug("destroy", new Object[0]);
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        this.ensureInitialized(event.getResource());
        AtmosphereResponse response = ((AtmosphereResourceImpl)event.getResource()).getResponse(false);
        if (event.getMessage() != null && List.class.isAssignableFrom(event.getMessage().getClass())) {
            List messages = (List)List.class.cast(event.getMessage());
            for (String t : messages) {
                this.onMessage(event, response, t);
            }
        } else if (event.isClosedByApplication() || event.isClosedByClient() || event.isCancelled()) {
            this.onDisconnect(event, response);
        } else if (event.isSuspended()) {
            this.onMessage(event, response, (String)event.getMessage());
        } else if (event.isResuming()) {
            this.onResume(event, response);
        } else if (event.isResumedOnTimeout()) {
            this.onTimeout(event, response);
        }
    }

    public void onOpen(AtmosphereResource resource) throws IOException {
        this.setStatus(resource, UserStatus.ACTIVE);
        this.incrementUserSessionCount(resource);
    }

    public void onResume(AtmosphereResourceEvent event, AtmosphereResponse response) throws IOException {
        LOGGER.debug("onResume", new Object[0]);
    }

    public void onTimeout(AtmosphereResourceEvent event, AtmosphereResponse response) throws IOException {
        LOGGER.debug("onTimeout", new Object[0]);
    }

    public void onDisconnect(AtmosphereResourceEvent event, AtmosphereResponse response) throws IOException {
        this.onDisconnectOrClose(event);
    }

    public void onClose(AtmosphereResourceEvent event, AtmosphereResponse response) {
        this.onDisconnectOrClose(event);
    }

    private void onDisconnectOrClose(AtmosphereResourceEvent event) {
        if (event.getResource().getRequest().getSession() == null) {
            return;
        }
        boolean lastSession = this.decrementUserSessionCount(event.getResource());
        if (lastSession) {
            LOGGER.info("last session for user %s", new Object[]{this.getCurrentUserId(event.getResource())});
            this.setStatus(event.getResource(), UserStatus.OFFLINE);
        }
    }

    public void onMessage(AtmosphereResourceEvent event, AtmosphereResponse response, String message) throws IOException {
        try {
            if (!StringUtils.isBlank((String)message)) {
                this.processRequestData(event.getResource(), message);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not handle async message: " + message, (Throwable)ex);
        }
        if (message != null) {
            response.write(message);
        } else {
            this.onDisconnectOrClose(event);
        }
    }

    private void processRequestData(AtmosphereResource resource, String message) {
        JSONObject messageJson = new JSONObject(message);
        String type = messageJson.optString("type", null);
        if (type != null) {
            switch (type) {
                case "setActiveWorkspace": {
                    String authUserId = this.getCurrentUserId(resource);
                    JSONObject dataJson = messageJson.optJSONObject("data");
                    if (dataJson == null) break;
                    String workspaceId = dataJson.getString("workspaceId");
                    String userId = dataJson.getString("userId");
                    if (!userId.equals(authUserId)) break;
                    this.switchWorkspace(authUserId, workspaceId);
                }
            }
        }
    }

    private void switchWorkspace(String authUserId, String workspaceId) {
        if (!workspaceId.equals(this.userRepository.getCurrentWorkspaceId(authUserId))) {
            User authUser = this.userRepository.findById(authUserId);
            Workspace workspace = this.workspaceRepository.findById(workspaceId, authUser);
            this.userRepository.setCurrentWorkspace(authUserId, workspace.getWorkspaceId());
            this.workQueueRepository.pushUserCurrentWorkspaceChange(authUser, workspace.getWorkspaceId());
            LOGGER.debug("User %s switched current workspace to %s", new Object[]{authUserId, workspaceId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(AtmosphereResource resource, UserStatus status) {
        broadcaster = resource.getBroadcaster();
        try {
            String authUserId = CurrentUser.getUserId((HttpServletRequest)resource.getRequest());
            Preconditions.checkNotNull((Object)authUserId, (Object)"Could not find user in session");
            User authUser = this.userRepository.findById(authUserId);
            Preconditions.checkNotNull((Object)authUser, (Object)("Could not find user with id: " + authUserId));
            if (authUser.getUserStatus() != status) {
                LOGGER.debug("Setting user %s status to %s", new Object[]{authUserId, status.toString()});
                this.userRepository.setStatus(authUserId, status);
                this.workQueueRepository.pushUserStatusChange(authUser, status);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not update status", (Throwable)ex);
        }
    }

    private void incrementUserSessionCount(AtmosphereResource resource) {
        String userId = this.getCurrentUserId(resource);
        boolean autoDelete = resource.transport() != AtmosphereResource.TRANSPORT.WEBSOCKET;
        this.userSessionCounterRepository.updateSession(userId, resource.uuid(), autoDelete);
    }

    private boolean decrementUserSessionCount(AtmosphereResource resource) {
        String userId = this.getCurrentUserId(resource);
        return this.userSessionCounterRepository.deleteSession(userId, resource.uuid()) < 1;
    }

    private String getCurrentUserId(AtmosphereResource resource) {
        if (resource.getRequest().getSession() == null) {
            return null;
        }
        String userId = CurrentUser.getUserId((HttpServletRequest)resource.getRequest());
        if (userId != null && userId.trim().length() > 0) {
            return userId;
        }
        throw new VisalloException("failed to get a current userId via an AtmosphereResource");
    }

    @Inject
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Inject
    public void setWorkspaceRepository(WorkspaceRepository workspaceRepository) {
        this.workspaceRepository = workspaceRepository;
    }

    @Inject
    public void setWorkQueueRepository(WorkQueueRepository workQueueRepository) {
        this.workQueueRepository = workQueueRepository;
    }

    @Inject
    public void setUserSessionCounterRepository(UserSessionCounterRepository userSessionCounterRepository) {
        this.userSessionCounterRepository = userSessionCounterRepository;
    }

    @Inject
    public void setMetricsManager(JmxMetricsManager metricsManager) {
        String namePrefix = metricsManager.getNamePrefix((Object)this);
        for (AtmosphereResource.TRANSPORT transport : AtmosphereResource.TRANSPORT.values()) {
            this.requestsCounters.put(transport, metricsManager.counter(namePrefix + transport.name()));
        }
    }
}

