/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.common.util.concurrent.RateLimiter;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.RequestResponseHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RateLimitFilter
implements RequestResponseHandler {
    private static final Map<String, RateLimiter> rateLimiters = new HashMap<String, RateLimiter>();
    public static final int PERMITS_PER_SECOND = 1;
    private static final int TOO_MANY_REQUESTS = 429;

    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) throws Exception {
        String url = request.getRequestURI();
        RateLimiter rateLimiter = this.getRateLimiterForUri(url);
        if (rateLimiter.tryAcquire(1L, TimeUnit.SECONDS)) {
            chain.next(request, response);
            return;
        }
        response.sendError(429, "Rate limit reached");
    }

    private RateLimiter getRateLimiterForUri(String url) {
        RateLimiter rateLimiter = rateLimiters.get(url);
        if (rateLimiter == null) {
            rateLimiter = RateLimiter.create((double)1.0);
            rateLimiters.put(url, rateLimiter);
        }
        return rateLimiter;
    }
}

