/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import com.google.inject.Inject;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.parameterProviders.ParameterProvider;
import com.v5analytics.webster.parameterProviders.ParameterProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.vertexium.Authorizations;
import org.vertexium.SecurityVertexiumException;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

public class AuthorizationsParameterProviderFactory
extends ParameterProviderFactory<Authorizations> {
    private final ParameterProvider<Authorizations> parameterProvider;

    @Inject
    public AuthorizationsParameterProviderFactory(final WorkspaceRepository workspaceRepository, UserRepository userRepository, Configuration configuration, final AuthorizationRepository authorizationRepository) {
        this.parameterProvider = new VisalloBaseParameterProvider<Authorizations>(userRepository, configuration){

            public Authorizations getParameter(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
                return AuthorizationsParameterProviderFactory.getAuthorizations(request, this.getUserRepository(), authorizationRepository, workspaceRepository);
            }
        };
    }

    public static Authorizations getAuthorizations(HttpServletRequest request, UserRepository userRepository, AuthorizationRepository authorizationRepository, WorkspaceRepository workspaceRepository) {
        User user = VisalloBaseParameterProvider.getUser(request, userRepository);
        if (user == null) {
            return null;
        }
        String workspaceId = VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault(request);
        if (workspaceId != null) {
            try {
                if (!workspaceRepository.hasReadPermissions(workspaceId, user)) {
                    throw new VisalloAccessDeniedException("You do not have access to workspace: " + workspaceId, user, (Object)workspaceId);
                }
            }
            catch (SecurityVertexiumException e) {
                throw new VisalloAccessDeniedException("Error getting access to requested workspace: " + workspaceId, user, (Object)workspaceId);
            }
            return authorizationRepository.getGraphAuthorizations(user, new String[]{workspaceId});
        }
        return authorizationRepository.getGraphAuthorizations(user, new String[0]);
    }

    public boolean isHandled(Method handleMethod, Class<? extends Authorizations> parameterType, Annotation[] parameterAnnotations) {
        return Authorizations.class.isAssignableFrom(parameterType);
    }

    public ParameterProvider<Authorizations> createParameterProvider(Method handleMethod, Class<?> parameterType, Annotation[] parameterAnnotations) {
        return this.parameterProvider;
    }
}

