/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import com.google.inject.Inject;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.parameterProviders.ParameterProvider;
import com.v5analytics.webster.parameterProviders.ParameterProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.UserRepository;
import org.visallo.web.WebConfiguration;
import org.visallo.web.parameterProviders.JustificationText;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

public class JustificationTextParameterProviderFactory
extends ParameterProviderFactory<String> {
    public static final String JUSTIFICATION_TEXT = "justificationText";
    private final ParameterProvider<String> parameterProvider;

    @Inject
    public JustificationTextParameterProviderFactory(UserRepository userRepository, Configuration configuration) {
        final boolean isJustificationRequired = WebConfiguration.justificationRequired(configuration);
        this.parameterProvider = new VisalloBaseParameterProvider<String>(userRepository, configuration){

            public String getParameter(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
                String propertyName = 1.getOptionalParameter(request, "propertyName");
                if (propertyName != null && propertyName.length() > 0) {
                    boolean isComment = VisalloProperties.COMMENT.isSameName(propertyName);
                    String sourceInfo = 1.getOptionalParameter(request, "sourceInfo");
                    return this.getJustificationText(isComment, sourceInfo, request);
                }
                return this.justificationParameter(isJustificationRequired, request);
            }

            public String getJustificationText(boolean isComment, String sourceInfo, HttpServletRequest request) {
                return this.justificationParameter(this.isJustificationRequired(isComment, sourceInfo), request);
            }

            public boolean isJustificationRequired(boolean isComment, String sourceInfo) {
                return !isComment && sourceInfo == null && isJustificationRequired;
            }

            private String justificationParameter(boolean required, HttpServletRequest request) {
                return required ? 1.getRequiredParameter(request, JustificationTextParameterProviderFactory.JUSTIFICATION_TEXT) : 1.getOptionalParameter(request, JustificationTextParameterProviderFactory.JUSTIFICATION_TEXT);
            }
        };
    }

    public boolean isHandled(Method handleMethod, Class<? extends String> parameterType, Annotation[] parameterAnnotations) {
        return JustificationTextParameterProviderFactory.getJustificationTextAnnotation(parameterAnnotations) != null;
    }

    public ParameterProvider<String> createParameterProvider(Method handleMethod, Class<?> parameterType, Annotation[] parameterAnnotations) {
        return this.parameterProvider;
    }

    private static JustificationText getJustificationTextAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof JustificationText)) continue;
            return (JustificationText)annotation;
        }
        return null;
    }
}

