/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.ServletContextTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.visallo.core.config.Configuration;
import org.visallo.web.WebApp;

public class Index
implements ParameterizedHandler {
    private static final String PLUGIN_JS_RESOURCES_BEFORE_AUTH_PARAM = "pluginJsResourcesBeforeAuth";
    private static final String PLUGIN_JS_RESOURCES_WEB_WORKER_PARAM = "pluginJsResourcesWebWorker";
    private static final String PLUGIN_JS_RESOURCES_AFTER_AUTH_PARAM = "pluginJsResourcesAfterAuth";
    private static final String PLUGIN_CSS_RESOURCES_PARAM = "pluginCssResources";
    private static final String LOGO_IMAGE_DATA_URI = "logoDataUri";
    private static final String SHOW_VERSION_COMMENTS = "showVersionComments";
    private static final String LOGO_PATH_BUNDLE_KEY = "visallo.loading-logo.path";
    private static final String CONTEXT_PATH = "contextPath";
    private static final Map<String, String> MESSAGE_BUNDLE_PARAMS = ImmutableMap.of((Object)"title", (Object)"visallo.title", (Object)"description", (Object)"visallo.description");
    private String indexHtml;
    private boolean showVersionComments;

    @Inject
    public Index(Configuration configuration) {
        this.showVersionComments = configuration.getBoolean("web.ui.showVersionComments", true);
    }

    @Handle
    public void handle(WebApp webApp, ResourceBundle resourceBundle, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/html");
        response.getWriter().write(this.getIndexHtml(request, webApp, resourceBundle));
    }

    private String getIndexHtml(HttpServletRequest request, WebApp app, ResourceBundle resourceBundle) throws IOException {
        if (this.indexHtml == null || app.isDevModeEnabled()) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(CONTEXT_PATH, request.getContextPath());
            context.put(PLUGIN_JS_RESOURCES_BEFORE_AUTH_PARAM, app.getPluginsJsResourcesBeforeAuth());
            context.put(PLUGIN_JS_RESOURCES_WEB_WORKER_PARAM, app.getPluginsJsResourcesWebWorker());
            context.put(PLUGIN_JS_RESOURCES_AFTER_AUTH_PARAM, app.getPluginsJsResourcesAfterAuth());
            context.put(PLUGIN_CSS_RESOURCES_PARAM, app.getPluginsCssResources());
            context.put(LOGO_IMAGE_DATA_URI, this.getLogoImageDataUri(request, resourceBundle));
            context.put(SHOW_VERSION_COMMENTS, this.showVersionComments);
            for (Map.Entry<String, String> param : MESSAGE_BUNDLE_PARAMS.entrySet()) {
                context.put(param.getKey(), resourceBundle.getString(param.getValue()));
            }
            ServletContextTemplateLoader templateLoader = new ServletContextTemplateLoader(request.getServletContext(), "/", ".hbs");
            Handlebars handlebars = new Handlebars((TemplateLoader)templateLoader);
            Template template = handlebars.compile("index");
            this.indexHtml = template.apply(context);
        }
        return this.indexHtml;
    }

    private String getLogoImageDataUri(HttpServletRequest request, ResourceBundle resourceBundle) throws IOException {
        String logoPathBundleKey = resourceBundle.getString(LOGO_PATH_BUNDLE_KEY);
        Preconditions.checkNotNull((Object)logoPathBundleKey, (Object)"visallo.loading-logo.path configuration not found");
        try (InputStream is = this.getResourceAsStream(request, logoPathBundleKey);){
            Preconditions.checkNotNull((Object)is, (Object)(logoPathBundleKey + " resource not found"));
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            String string = "data:image/png;base64," + DatatypeConverter.printBase64Binary((byte[])bytes);
            return string;
        }
    }

    private InputStream getResourceAsStream(HttpServletRequest request, String path) {
        InputStream is = request.getServletContext().getResourceAsStream(path);
        if (is == null) {
            is = this.getClass().getResourceAsStream(path);
        }
        return is;
    }
}

