/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.config;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import java.io.File;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.web.VisalloResponse;

public class Plugin
implements ParameterizedHandler {
    private static final String WEB_PLUGINS_PREFIX = "web.plugins.";
    private static final String DEFAULT_PLUGINS_DIR = "/jsc/configuration/plugins";
    private final Configuration configuration;

    @Inject
    public Plugin(Configuration configuration) {
        this.configuration = configuration;
    }

    @Handle
    public void handle(HttpServletRequest request, @Required(name="pluginName") String pluginName, VisalloResponse response) throws Exception {
        String searchString;
        String uri;
        String pluginResourcePath;
        String configurationKey = WEB_PLUGINS_PREFIX + pluginName;
        String pluginPath = this.configuration.get(configurationKey, null);
        if (pluginPath == null) {
            pluginPath = request.getServletContext().getResource("/jsc/configuration/plugins/" + pluginName).getPath();
        }
        if ((pluginResourcePath = (uri = request.getRequestURI()).substring(uri.indexOf(searchString = "/" + pluginName + "/") + searchString.length())).endsWith(".js")) {
            response.setContentType("application/x-javascript");
        } else if (pluginResourcePath.endsWith(".ejs")) {
            response.setContentType("text/plain");
        } else if (pluginResourcePath.endsWith(".css")) {
            response.setContentType("text/css");
        } else if (pluginResourcePath.endsWith(".html")) {
            response.setContentType("text/html");
        } else {
            throw new VisalloResourceNotFoundException("Only js,ejs,css,html files served from plugin");
        }
        String filePath = FilenameUtils.concat((String)pluginPath, (String)pluginResourcePath);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new VisalloResourceNotFoundException("Could not find file: " + filePath);
        }
        response.setCharacterEncoding("UTF-8");
        FileUtils.copyFile((File)file, (OutputStream)response.getOutputStream());
    }
}

