/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.edge;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.JsonSerializer;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiSourceInfo;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.parameterProviders.JustificationText;
import org.visallo.web.util.VisibilityValidator;

public class EdgeCreate
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(EdgeCreate.class);
    private final Graph graph;
    private final WorkQueueRepository workQueueRepository;
    private final GraphRepository graphRepository;
    private final VisibilityTranslator visibilityTranslator;

    @Inject
    public EdgeCreate(Graph graph, WorkQueueRepository workQueueRepository, GraphRepository graphRepository, VisibilityTranslator visibilityTranslator) {
        this.graph = graph;
        this.workQueueRepository = workQueueRepository;
        this.graphRepository = graphRepository;
        this.visibilityTranslator = visibilityTranslator;
    }

    @Handle
    public ClientApiElement handle(@Optional(name="edgeId") String edgeId, @Required(name="outVertexId") String outVertexId, @Required(name="inVertexId") String inVertexId, @Required(name="predicateLabel") String predicateLabel, @Required(name="visibilitySource") String visibilitySource, @JustificationText String justificationText, ClientApiSourceInfo sourceInfo, @ActiveWorkspaceId String workspaceId, ResourceBundle resourceBundle, User user, Authorizations authorizations) throws Exception {
        Vertex inVertex = this.graph.getVertex(inVertexId, authorizations);
        Vertex outVertex = this.graph.getVertex(outVertexId, authorizations);
        VisibilityValidator.validate(this.graph, this.visibilityTranslator, resourceBundle, visibilitySource, user, authorizations);
        Edge edge = this.graphRepository.addEdge(edgeId, outVertex, inVertex, predicateLabel, justificationText, sourceInfo, visibilitySource, workspaceId, user, authorizations);
        this.graph.flush();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Statement created:\n" + JsonSerializer.toJson((Element)edge, (String)workspaceId, (Authorizations)authorizations).toString(2), new Object[0]);
        }
        this.workQueueRepository.broadcastElement((Element)edge, workspaceId);
        this.workQueueRepository.pushElement((Element)edge, Priority.HIGH);
        return ClientApiConverter.toClientApi((Element)edge, (String)workspaceId, (Authorizations)authorizations);
    }
}

