/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.edge;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.Locale;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Graph;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.web.clientapi.model.ClientApiHistoricalPropertyResults;

public class EdgeGetHistory
implements ParameterizedHandler {
    private Graph graph;

    @Inject
    public EdgeGetHistory(Graph graph) {
        this.graph = graph;
    }

    @Handle
    public ClientApiHistoricalPropertyResults handle(@Required(name="graphEdgeId") String graphEdgeId, @Optional(name="startTime") Long startTime, @Optional(name="endTime") Long endTime, Locale locale, ResourceBundle resourceBundle, Authorizations authorizations) throws Exception {
        Edge edge = this.graph.getEdge(graphEdgeId, authorizations);
        if (edge == null) {
            throw new VisalloResourceNotFoundException(String.format("edge %s not found", graphEdgeId));
        }
        Iterable historicalPropertyValues = edge.getHistoricalPropertyValues(startTime, endTime, authorizations);
        return ClientApiConverter.toClientApi((Iterable)historicalPropertyValues, (Locale)locale, (ResourceBundle)resourceBundle);
    }
}

