/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.notification;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.visallo.core.model.notification.SystemNotification;
import org.visallo.core.model.notification.SystemNotificationRepository;
import org.visallo.core.model.notification.UserNotificationRepository;
import org.visallo.core.user.User;

public class Notifications
implements ParameterizedHandler {
    private final SystemNotificationRepository systemNotificationRepository;
    private final UserNotificationRepository userNotificationRepository;

    @Inject
    public Notifications(SystemNotificationRepository systemNotificationRepository, UserNotificationRepository userNotificationRepository) {
        this.systemNotificationRepository = systemNotificationRepository;
        this.userNotificationRepository = userNotificationRepository;
    }

    @Handle
    public JSONObject handle(@Optional(name="futureDays", defaultValue="10") int futureDays, User user) throws Exception {
        JSONObject notifications = new JSONObject();
        JSONObject systemNotifications = new JSONObject();
        JSONArray activeNotifications = new JSONArray();
        for (SystemNotification notification2 : this.systemNotificationRepository.getActiveNotifications(user)) {
            activeNotifications.put((Object)notification2.toJSONObject());
        }
        systemNotifications.put("active", (Object)activeNotifications);
        Date maxDate = DateUtils.addDays((Date)new Date(), (int)futureDays);
        JSONArray futureNotifications = new JSONArray();
        for (SystemNotification notification3 : this.systemNotificationRepository.getFutureNotifications(maxDate, user)) {
            futureNotifications.put((Object)notification3.toJSONObject());
        }
        systemNotifications.put("future", (Object)futureNotifications);
        JSONArray userNotifications = new JSONArray();
        this.userNotificationRepository.getActiveNotifications(user).map(notification -> notification.toJSONObject()).forEach(json -> userNotifications.put(json));
        notifications.put("system", (Object)systemNotifications);
        notifications.put("user", (Object)userNotifications);
        return notifications;
    }
}

