/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.resource;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.http.HttpRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.util.ImageUtils;
import org.visallo.web.VisalloResponse;

public class ResourceExternalGet
implements ParameterizedHandler {
    private final Graph graph;
    private final HttpRepository httpRepository;

    @Inject
    public ResourceExternalGet(Graph graph, HttpRepository httpRepository) {
        this.graph = graph;
        this.httpRepository = httpRepository;
    }

    @Handle
    public void handle(Authorizations authorizations, @Required(name="vId") String vertexId, @Required(name="url") String url, @Required(name="maxWidth") int maxWidth, @Required(name="maxHeight") int maxHeight, @Optional(name="jpegQuality", defaultValue="80") int jpegQuality, VisalloResponse response) throws Exception {
        InputStream in;
        String propertyKey = this.getPropertyKey(url, maxWidth, maxHeight, jpegQuality);
        Vertex vertex = this.graph.getVertex(vertexId, authorizations);
        if (vertex == null) {
            throw new VisalloResourceNotFoundException("Could not find vertex: " + vertexId);
        }
        StreamingPropertyValue cachedImageValue = (StreamingPropertyValue)VisalloProperties.CACHED_IMAGE.getPropertyValue((Element)vertex, propertyKey);
        if (cachedImageValue != null) {
            in = cachedImageValue.getInputStream();
        } else {
            byte[] imageData = this.createAndSaveCachedImage(vertex, propertyKey, url, maxWidth, maxHeight, jpegQuality, authorizations);
            in = new ByteArrayInputStream(imageData);
        }
        ImageUtils.ImageFormat imageFormat = ImageUtils.getImageFormat((InputStream)in);
        String imageMimeType = imageFormat.getImageMimeType();
        if (imageMimeType == null) {
            imageMimeType = "image";
        }
        response.setContentType(imageMimeType);
        response.addHeader("Content-Disposition", "inline; filename=thumbnail-" + maxWidth + "x" + maxHeight + ".jpg");
        response.setMaxAge(3600);
        response.write(imageFormat.getPushBackIn());
    }

    private byte[] createAndSaveCachedImage(Vertex vertex, String propertyKey, String url, int maxWidth, int maxHeight, int jpegQuality, Authorizations authorizations) throws IOException {
        byte[] imageData = this.getAndSaveImageData(vertex, url, authorizations);
        imageData = ImageUtils.resize((byte[])imageData, (int)maxWidth, (int)maxHeight, (int)jpegQuality);
        StreamingPropertyValue value = new StreamingPropertyValue((InputStream)new ByteArrayInputStream(imageData), byte[].class);
        value.store(true).searchIndex(false);
        ExistingElementMutation m = vertex.prepareMutation();
        VisalloProperties.CACHED_IMAGE.addPropertyValue((ElementMutation)m, propertyKey, (Object)value, vertex.getVisibility());
        m.save(authorizations);
        return imageData;
    }

    private byte[] getAndSaveImageData(Vertex vertex, String url, Authorizations authorizations) throws IOException {
        String propertyKey = this.getPropertyKey(url, null, null, null);
        StreamingPropertyValue originalImage = (StreamingPropertyValue)VisalloProperties.CACHED_IMAGE.getPropertyValue((Element)vertex, propertyKey);
        if (originalImage != null) {
            return IOUtils.toByteArray((InputStream)originalImage.getInputStream());
        }
        byte[] imageData = this.httpRepository.get(url);
        StreamingPropertyValue value = new StreamingPropertyValue((InputStream)new ByteArrayInputStream(imageData), byte[].class);
        value.store(true).searchIndex(false);
        ExistingElementMutation m = vertex.prepareMutation();
        VisalloProperties.CACHED_IMAGE.addPropertyValue((ElementMutation)m, propertyKey, (Object)value, vertex.getVisibility());
        m.save(authorizations);
        return imageData;
    }

    private String getPropertyKey(String url, Integer maxWidth, Integer maxHeight, Integer jpegQuality) {
        String result = url;
        if (maxWidth != null) {
            result = result + "-" + Integer.toString(maxWidth);
        }
        if (maxHeight != null) {
            result = result + "-" + Integer.toString(maxHeight);
        }
        if (jpegQuality != null) {
            result = result + "-" + Integer.toString(jpegQuality);
        }
        return result;
    }
}

