/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.Date;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.visallo.core.model.PropertyJustificationMetadata;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionBuilder;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSourceInfo;
import org.visallo.web.clientapi.model.ClientApiSuccess;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.parameterProviders.JustificationText;
import org.visallo.web.util.VisibilityValidator;

public class ResolveTermEntity
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ResolveTermEntity.class);
    private static final String MULTI_VALUE_KEY = ResolveTermEntity.class.getName();
    private final Graph graph;
    private final OntologyRepository ontologyRepository;
    private final VisibilityTranslator visibilityTranslator;
    private final WorkspaceRepository workspaceRepository;
    private final WorkQueueRepository workQueueRepository;
    private String artifactHasEntityIri;

    @Inject
    public ResolveTermEntity(Graph graphRepository, OntologyRepository ontologyRepository, VisibilityTranslator visibilityTranslator, WorkspaceRepository workspaceRepository, WorkQueueRepository workQueueRepository) {
        this.graph = graphRepository;
        this.ontologyRepository = ontologyRepository;
        this.visibilityTranslator = visibilityTranslator;
        this.workspaceRepository = workspaceRepository;
        this.workQueueRepository = workQueueRepository;
        this.artifactHasEntityIri = ontologyRepository.getRelationshipIRIByIntent("artifactHasEntity");
        if (this.artifactHasEntityIri == null) {
            LOGGER.warn("'artifactHasEntity' intent has not been defined. Please update your ontology.", new Object[0]);
        }
    }

    @Handle
    public ClientApiSuccess handle(@Required(name="artifactId") String artifactId, @Required(name="propertyKey") String propertyKey, @Required(name="propertyName") String propertyName, @Required(name="mentionStart") long mentionStart, @Required(name="mentionEnd") long mentionEnd, @Required(name="sign") String title, @Required(name="conceptId") String conceptId, @Required(name="visibilitySource") String visibilitySource, @Optional(name="resolvedVertexId") String resolvedVertexId, @Optional(name="sourceInfo") String sourceInfoString, @JustificationText String justificationText, @ActiveWorkspaceId String workspaceId, ResourceBundle resourceBundle, User user, Authorizations authorizations) throws Exception {
        Vertex vertex;
        if (this.artifactHasEntityIri == null) {
            this.artifactHasEntityIri = this.ontologyRepository.getRequiredRelationshipIRIByIntent("artifactHasEntity");
        }
        Workspace workspace = this.workspaceRepository.findById(workspaceId, user);
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, (String)visibilitySource, (String)workspaceId);
        VisibilityValidator.validate(this.graph, this.visibilityTranslator, resourceBundle, visibilityJson, user, authorizations);
        String id = resolvedVertexId == null ? this.graph.getIdGenerator().nextId() : resolvedVertexId;
        Concept concept = this.ontologyRepository.getConceptByIRI(conceptId);
        Vertex artifactVertex = this.graph.getVertex(artifactId, authorizations);
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        Metadata metadata = new Metadata();
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, (Object)visibilityJson, defaultVisibility);
        if (resolvedVertexId != null) {
            vertex = this.graph.getVertex(id, authorizations);
        } else {
            VertexBuilder vertexMutation = this.graph.prepareVertex(id, visalloVisibility.getVisibility());
            VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation)vertexMutation, (Object)conceptId, defaultVisibility);
            VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)vertexMutation, (Object)visibilityJson, defaultVisibility);
            VisalloProperties.MODIFIED_BY.setProperty((ElementMutation)vertexMutation, (Object)user.getUserId(), defaultVisibility);
            VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation)vertexMutation, (Object)new Date(), defaultVisibility);
            VisalloProperties.TITLE.addPropertyValue((ElementMutation)vertexMutation, MULTI_VALUE_KEY, (Object)title, metadata, visalloVisibility.getVisibility());
            if (justificationText != null) {
                PropertyJustificationMetadata propertyJustificationMetadata = new PropertyJustificationMetadata(justificationText);
                VisalloProperties.JUSTIFICATION.setProperty((ElementMutation)vertexMutation, (Object)propertyJustificationMetadata, visalloVisibility.getVisibility());
            }
            vertex = (Vertex)vertexMutation.save(authorizations);
            this.graph.flush();
            this.workspaceRepository.updateEntityOnWorkspace(workspace, vertex.getId(), null, null, user);
        }
        EdgeBuilder edgeBuilder = this.graph.prepareEdge(artifactVertex, vertex, this.artifactHasEntityIri, visalloVisibility.getVisibility());
        VisalloProperties.MODIFIED_BY.setProperty((ElementMutation)edgeBuilder, (Object)user.getUserId(), defaultVisibility);
        VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation)edgeBuilder, (Object)new Date(), defaultVisibility);
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)edgeBuilder, (Object)visibilityJson, defaultVisibility);
        Edge edge = edgeBuilder.save(authorizations);
        ClientApiSourceInfo sourceInfo = ClientApiSourceInfo.fromString((String)sourceInfoString);
        new TermMentionBuilder().outVertex(artifactVertex).propertyKey(propertyKey).propertyName(propertyName).start(mentionStart).end(mentionEnd).title(title).snippet(sourceInfo == null ? null : sourceInfo.snippet).conceptIri(concept.getIRI()).visibilityJson(visibilityJson).resolvedTo(vertex, edge).process(this.getClass().getSimpleName()).save(this.graph, this.visibilityTranslator, user, authorizations);
        this.graph.flush();
        this.workQueueRepository.pushTextUpdated(artifactId);
        this.workQueueRepository.pushElement((Element)edge, Priority.HIGH);
        return VisalloResponse.SUCCESS;
    }
}

