/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workspace.WorkspaceHelper;
import org.visallo.core.security.ACLProvider;
import org.visallo.core.user.User;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSuccess;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class VertexDeleteProperty
implements ParameterizedHandler {
    private final Graph graph;
    private final WorkspaceHelper workspaceHelper;
    private final OntologyRepository ontologyRepository;
    private final ACLProvider aclProvider;
    private final boolean autoPublishComments;

    @Inject
    public VertexDeleteProperty(Graph graph, WorkspaceHelper workspaceHelper, OntologyRepository ontologyRepository, ACLProvider aclProvider, Configuration configuration) {
        this.graph = graph;
        this.workspaceHelper = workspaceHelper;
        this.ontologyRepository = ontologyRepository;
        this.aclProvider = aclProvider;
        this.autoPublishComments = configuration.getBoolean("comments.autoPublish", false);
    }

    @Handle
    public ClientApiSuccess handle(HttpServletRequest request, @Required(name="graphVertexId") String graphVertexId, @Required(name="propertyKey") String propertyKey, @Required(name="propertyName") String propertyName, @ActiveWorkspaceId String workspaceId, User user, Authorizations authorizations) throws Exception {
        OntologyProperty ontologyProperty = this.ontologyRepository.getRequiredPropertyByIRI(propertyName);
        Vertex vertex = this.graph.getVertex(graphVertexId, authorizations);
        this.aclProvider.checkCanDeleteProperty((Element)vertex, propertyKey, propertyName, user);
        boolean isComment = VisalloProperties.COMMENT.isSameName(propertyName);
        if (isComment && request.getPathInfo().equals("/vertex/property")) {
            throw new VisalloException("Use /vertex/comment to save comment properties");
        }
        if (request.getPathInfo().equals("/vertex/comment") && !isComment) {
            throw new VisalloException("Use /vertex/property to save non-comment properties");
        }
        if (isComment && this.autoPublishComments) {
            workspaceId = null;
        }
        this.workspaceHelper.deleteProperties((Element)vertex, propertyKey, propertyName, ontologyProperty, workspaceId, authorizations, user);
        return VisalloResponse.SUCCESS;
    }
}

