/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.List;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.trace.Trace;
import org.visallo.core.trace.TraceSpan;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.clientapi.model.ClientApiVertexEdges;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class VertexEdges
implements ParameterizedHandler {
    private final Graph graph;

    @Inject
    public VertexEdges(Graph graph) {
        this.graph = graph;
    }

    @Handle
    public ClientApiVertexEdges handle(@Required(name="graphVertexId") String graphVertexId, @Optional(name="offset", defaultValue="0") int offset, @Optional(name="size", defaultValue="25") int size, @Optional(name="edgeLabel") String edgeLabel, @Optional(name="relatedVertexId") String relatedVertexId, @Optional(name="direction", defaultValue="BOTH") String directionStr, @ActiveWorkspaceId String workspaceId, Authorizations authorizations) throws Exception {
        Map<String, Vertex> vertices;
        Vertex vertex;
        Vertex relatedVertex = null;
        try (TraceSpan trace = Trace.start((String)"getOriginalVertex").data("graphVertexId", graphVertexId);){
            vertex = this.graph.getVertex(graphVertexId, authorizations);
            if (vertex == null) {
                throw new VisalloResourceNotFoundException("Could not find vertex: " + graphVertexId);
            }
        }
        if (relatedVertexId != null && (relatedVertex = this.graph.getVertex(relatedVertexId, authorizations)) == null) {
            throw new VisalloResourceNotFoundException("Could not find related vertex: " + relatedVertexId);
        }
        Direction direction = Direction.valueOf((String)directionStr.toUpperCase());
        List<String> edgeIds = this.loadEdgeIds(edgeLabel, vertex, relatedVertex, direction, authorizations);
        int totalEdgeCount = edgeIds.size();
        ClientApiVertexEdges result = new ClientApiVertexEdges();
        edgeIds = edgeIds.subList(Math.min(edgeIds.size(), offset), Math.min(edgeIds.size(), offset + size));
        List<Edge> edges = this.loadEdges(edgeIds, authorizations);
        try (TraceSpan trace = Trace.start((String)"getConnectedVertices").data("graphVertexId", vertex.getId());){
            vertices = this.getVertices(vertex.getId(), edges, authorizations);
        }
        for (Edge edge : edges) {
            String otherVertexId = relatedVertexId == null ? edge.getOtherVertexId(vertex.getId()) : relatedVertexId;
            Vertex otherVertex = relatedVertex == null ? vertices.get(otherVertexId) : relatedVertex;
            result.getRelationships().add(this.convertEdgeToClientApi(edge, otherVertexId, otherVertex, workspaceId, authorizations));
        }
        result.setTotalReferences((long)totalEdgeCount);
        return result;
    }

    protected List<String> loadEdgeIds(String edgeLabel, Vertex vertex, Vertex relatedVertex, Direction direction, Authorizations authorizations) {
        if (edgeLabel == null && relatedVertex == null) {
            return Lists.newArrayList((Iterable)vertex.getEdgeIds(direction, authorizations));
        }
        if (relatedVertex == null) {
            return Lists.newArrayList((Iterable)vertex.getEdgeIds(direction, edgeLabel, authorizations));
        }
        if (edgeLabel == null) {
            return Lists.newArrayList((Iterable)vertex.getEdgeIds(relatedVertex, direction, authorizations));
        }
        return Lists.newArrayList((Iterable)vertex.getEdgeIds(relatedVertex, direction, edgeLabel, authorizations));
    }

    protected List<Edge> loadEdges(List<String> edgeIds, Authorizations authorizations) {
        return Lists.newArrayList((Iterable)this.graph.getEdges(edgeIds, authorizations));
    }

    protected ClientApiVertexEdges.Edge convertEdgeToClientApi(Edge edge, String otherVertexId, Vertex otherVertex, String workspaceId, Authorizations authorizations) {
        ClientApiVertex clientApiVertex;
        ClientApiVertexEdges.Edge clientApiEdge = new ClientApiVertexEdges.Edge();
        clientApiEdge.setRelationship(ClientApiConverter.toClientApiEdge((Edge)edge, (String)workspaceId));
        if (otherVertex == null) {
            clientApiVertex = new ClientApiVertex();
            clientApiVertex.setId(otherVertexId);
        } else {
            clientApiVertex = ClientApiConverter.toClientApiVertex((Vertex)otherVertex, (String)workspaceId, (Authorizations)authorizations);
        }
        clientApiEdge.setVertex(clientApiVertex);
        return clientApiEdge;
    }

    private Map<String, Vertex> getVertices(String myVertexId, List<Edge> edges, Authorizations authorizations) {
        Iterable<String> vertexIds = this.getOtherVertexIds(myVertexId, edges);
        Iterable vertices = this.graph.getVertices(vertexIds, ClientApiConverter.SEARCH_FETCH_HINTS, authorizations);
        vertices = Iterables.filter((Iterable)vertices, (Predicate)Predicates.notNull());
        return Maps.uniqueIndex((Iterable)vertices, (Function)new Function<Vertex, String>(){

            public String apply(Vertex vertex) {
                return vertex.getId();
            }
        });
    }

    private Iterable<String> getOtherVertexIds(final String myVertexId, List<Edge> edges) {
        return Iterables.transform(edges, (Function)new Function<Edge, String>(){

            public String apply(Edge edge) {
                return edge.getOtherVertexId(myVertexId);
            }
        });
    }
}

