/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.Locale;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.web.clientapi.model.ClientApiHistoricalPropertyResults;

public class VertexGetPropertyHistory
implements ParameterizedHandler {
    private Graph graph;

    @Inject
    public VertexGetPropertyHistory(Graph graph) {
        this.graph = graph;
    }

    @Handle
    public ClientApiHistoricalPropertyResults handle(@Required(name="graphVertexId") String graphVertexId, @Required(name="propertyKey") String propertyKey, @Required(name="propertyName") String propertyName, @Optional(name="startTime") Long startTime, @Optional(name="endTime") Long endTime, Locale locale, ResourceBundle resourceBundle, Authorizations authorizations) throws Exception {
        Vertex vertex = this.graph.getVertex(graphVertexId, authorizations);
        if (vertex == null) {
            throw new VisalloResourceNotFoundException(String.format("vertex %s not found", graphVertexId));
        }
        Property property = vertex.getProperty(propertyKey, propertyName);
        if (property == null) {
            throw new VisalloResourceNotFoundException(String.format("property %s:%s not found on vertex %s", propertyKey, propertyName, vertex.getId()));
        }
        Iterable historicalPropertyValues = vertex.getHistoricalPropertyValues(property.getKey(), property.getName(), property.getVisibility(), startTime, endTime, authorizations);
        return ClientApiConverter.toClientApi((Iterable)historicalPropertyValues, (Locale)locale, (ResourceBundle)resourceBundle);
    }
}

