/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.web.VisalloResponse;

public class VertexGetPropertyValue
implements ParameterizedHandler {
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=([0-9]*)-([0-9]*)");
    private Graph graph;

    @Inject
    public VertexGetPropertyValue(Graph graph) {
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handle
    public void handle(@Required(name="graphVertexId") String graphVertexId, @Required(name="propertyKey") String propertyKey, @Required(name="propertyName") String propertyName, @Optional(name="Range") String range, @Optional(name="download", defaultValue="false") boolean download, @Optional(name="playback", defaultValue="false") boolean playback, Authorizations authorizations, VisalloResponse response) throws Exception {
        long totalLength;
        InputStream in;
        PlaybackOptions playbackOptions = new PlaybackOptions();
        playbackOptions.range = range;
        playbackOptions.download = download;
        playbackOptions.playback = playback;
        Vertex vertex = this.graph.getVertex(graphVertexId, authorizations);
        if (vertex == null) {
            throw new VisalloResourceNotFoundException(String.format("vertex %s not found", graphVertexId));
        }
        Property property = vertex.getProperty(propertyKey, propertyName);
        if (property == null) {
            throw new VisalloResourceNotFoundException(String.format("property %s:%s not found on vertex %s", propertyKey, propertyName, vertex.getId()));
        }
        String fileName = (String)VisalloProperties.FILE_NAME.getOnlyPropertyValue((Element)vertex);
        String mimeType = this.getMimeType(property);
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        this.setFileNameHeaders(response, fileName, playbackOptions);
        if (property.getValue() instanceof StreamingPropertyValue) {
            StreamingPropertyValue streamingPropertyValue = (StreamingPropertyValue)property.getValue();
            in = streamingPropertyValue.getInputStream();
            totalLength = streamingPropertyValue.getLength();
        } else {
            byte[] value = property.getValue().toString().getBytes();
            in = new ByteArrayInputStream(value);
            totalLength = value.length;
        }
        try {
            if (playbackOptions.playback) {
                this.handlePartialPlayback(response, in, totalLength, playbackOptions);
            } else {
                this.handleFullPlayback(response, in);
            }
        }
        finally {
            in.close();
        }
    }

    private void setFileNameHeaders(VisalloResponse response, String fileName, PlaybackOptions playbackOptions) {
        if (playbackOptions.download) {
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
        } else {
            response.addHeader("Content-Disposition", "inline; filename=" + fileName);
        }
    }

    private void handleFullPlayback(VisalloResponse response, InputStream in) throws IOException {
        try (OutputStream out = response.getOutputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private void handlePartialPlayback(VisalloResponse response, InputStream in, long totalLength, PlaybackOptions playbackOptions) throws IOException {
        long partialStart = 0L;
        Long partialEnd = null;
        if (playbackOptions.range != null) {
            response.setStatus(206);
            Matcher m = RANGE_PATTERN.matcher(playbackOptions.range);
            if (m.matches()) {
                partialStart = Long.parseLong(m.group(1));
                if (m.group(2).length() > 0) {
                    partialEnd = Long.parseLong(m.group(2));
                }
            }
        }
        if (partialEnd == null) {
            partialEnd = totalLength;
        }
        partialEnd = Math.min(partialEnd, totalLength - 1L);
        long partialLength = totalLength;
        if (playbackOptions.range != null) {
            partialLength = partialEnd - partialStart + 1L;
            response.addHeader("Content-Range", "bytes " + partialStart + "-" + partialEnd + "/" + totalLength);
        }
        response.addHeader("Content-Length", "" + partialLength);
        try (OutputStream out = response.getOutputStream();){
            IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)partialStart, (long)partialLength);
        }
        response.flushBuffer();
    }

    private String getMimeType(Property property) {
        String mimeType = (String)VisalloProperties.MIME_TYPE_METADATA.getMetadataValue(property.getMetadata(), null);
        if (mimeType != null) {
            return mimeType;
        }
        return null;
    }

    public class PlaybackOptions {
        public String range;
        public boolean download;
        public boolean playback;
    }
}

