/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.artifactThumbnails.ArtifactThumbnailRepository;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.VisalloResponse;

public class VertexPosterFrame
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VertexPosterFrame.class);
    private final Graph graph;
    private final ArtifactThumbnailRepository artifactThumbnailRepository;

    @Inject
    public VertexPosterFrame(Graph graph, ArtifactThumbnailRepository artifactThumbnailRepository) {
        this.graph = graph;
        this.artifactThumbnailRepository = artifactThumbnailRepository;
    }

    @Handle
    public void handle(@Required(name="graphVertexId") String graphVertexId, @Optional(name="width") Integer width, Authorizations authorizations, User user, VisalloResponse response) throws Exception {
        block54: {
            Property rawPosterFrame;
            StreamingPropertyValue rawPosterFrameValue;
            int[] boundaryDims = new int[]{200, 200};
            Vertex artifactVertex = this.graph.getVertex(graphVertexId, authorizations);
            if (artifactVertex == null) {
                throw new VisalloResourceNotFoundException("Could not find vertex with id: " + graphVertexId);
            }
            if (width != null) {
                boundaryDims[0] = boundaryDims[1] = width.intValue();
                response.setContentType("image/jpeg");
                response.addHeader("Content-Disposition", "inline; filename=thumbnail" + boundaryDims[0] + ".jpg");
                response.setMaxAge(3600);
                byte[] thumbnailData = this.artifactThumbnailRepository.getThumbnailData(artifactVertex.getId(), "poster-frame", boundaryDims[0], boundaryDims[1], user);
                if (thumbnailData != null) {
                    LOGGER.debug("Cache hit for: %s (poster-frame) %d x %d", new Object[]{graphVertexId, boundaryDims[0], boundaryDims[1]});
                    try (OutputStream out = response.getOutputStream();){
                        out.write(thumbnailData);
                    }
                    return;
                }
            }
            if ((rawPosterFrameValue = (StreamingPropertyValue)MediaVisalloProperties.RAW_POSTER_FRAME.getPropertyValue(rawPosterFrame = MediaVisalloProperties.RAW_POSTER_FRAME.getOnlyProperty((Element)artifactVertex))) == null) {
                throw new VisalloResourceNotFoundException("Could not find raw poster from for artifact: " + artifactVertex.getId());
            }
            try (InputStream in = rawPosterFrameValue.getInputStream();){
                if (width != null) {
                    LOGGER.info("Cache miss for: %s (poster-frame) %d x %d", new Object[]{graphVertexId, boundaryDims[0], boundaryDims[1]});
                    response.setContentType("image/jpeg");
                    response.addHeader("Content-Disposition", "inline; filename=thumbnail" + boundaryDims[0] + ".jpg");
                    response.setMaxAge(3600);
                    byte[] thumbnailData = this.artifactThumbnailRepository.createThumbnail(artifactVertex, rawPosterFrame.getKey(), "poster-frame", in, boundaryDims, user).getData();
                    try (OutputStream out = response.getOutputStream();){
                        out.write(thumbnailData);
                        break block54;
                    }
                }
                response.setContentType("image/png");
                try (OutputStream out = response.getOutputStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
        }
    }
}

