/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.workspace;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.RelatedEdge;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiWorkspaceEdges;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class WorkspaceEdges
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceEdges.class);
    private final Graph graph;
    private final WorkspaceRepository workspaceRepository;

    @Inject
    public WorkspaceEdges(Graph graph, WorkspaceRepository workspaceRepository) {
        this.graph = graph;
        this.workspaceRepository = workspaceRepository;
    }

    @Handle
    public ClientApiWorkspaceEdges handle(HttpServletRequest request, @Optional(name="ids[]") String[] additionalVertexIds, @ActiveWorkspaceId String workspaceId, User user, Authorizations authorizations) throws Exception {
        if (additionalVertexIds == null) {
            additionalVertexIds = new String[]{};
        }
        long startTime = System.nanoTime();
        Workspace workspace = this.workspaceRepository.findById(workspaceId, user);
        List vertexIds = this.workspaceRepository.findEntityVertexIds(workspace, user);
        Collections.addAll(vertexIds, additionalVertexIds);
        ClientApiWorkspaceEdges results = this.getEdges(request, workspaceId, vertexIds, authorizations);
        long endTime = System.nanoTime();
        LOGGER.debug("Retrieved in %dms", new Object[]{(endTime - startTime) / 1000L / 1000L});
        return results;
    }

    protected ClientApiWorkspaceEdges getEdges(HttpServletRequest request, String workspaceId, Iterable<String> vertexIds, Authorizations authorizations) {
        ClientApiWorkspaceEdges edgeResult = new ClientApiWorkspaceEdges();
        Iterable relatedEdges = this.graph.findRelatedEdgeSummary(vertexIds, authorizations);
        for (RelatedEdge relatedEdge : relatedEdges) {
            edgeResult.add(relatedEdge.getEdgeId(), relatedEdge.getLabel(), relatedEdge.getOutVertexId(), relatedEdge.getInVertexId());
        }
        return edgeResult;
    }
}

