/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.fortesting;

import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.webpieces.nio.api.SSLEngineFactory;

public class SSLEngineFactoryWebServerTesting
implements SSLEngineFactory {
    private String serverKeystore = "/keystore.jks";
    private String password = "password";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLEngine createSslEngine() {
        try (InputStream keySt = SSLEngineFactoryWebServerTesting.class.getResourceAsStream(this.serverKeystore);){
            char[] passphrase = this.password.toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keySt, passphrase);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, passphrase);
            sslContext.init(kmf.getKeyManagers(), null, null);
            SSLEngine engine = sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            SSLEngine sSLEngine = engine;
            return sSLEngine;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

