/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.fortesting;

import com.google.inject.Module;
import java.io.File;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.plugins.fortesting.TestConfig;
import org.webpieces.router.api.RouterConfig;
import org.webpieces.templating.api.TemplateConfig;
import org.webpieces.util.cmdline2.Arguments;
import org.webpieces.util.cmdline2.CommandLineParser;
import org.webpieces.util.file.FileFactory;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.file.VirtualFileClasspath;
import org.webpieces.util.security.SecretKeyInfo;
import org.webpieces.webserver.api.WebServer;
import org.webpieces.webserver.api.WebServerConfig;
import org.webpieces.webserver.api.WebServerFactory;

public class WebserverForTest {
    private static final Logger log = LoggerFactory.getLogger(WebserverForTest.class);
    private File cacheDir = new File(System.getProperty("java.io.tmpdir") + "/webpiecesCache/webserverForTest");
    public static final Charset CHAR_SET_TO_USE = StandardCharsets.UTF_8;
    private WebServer webServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        new WebserverForTest(null, null, null, args).start();
        Class<WebserverForTest> clazz = WebserverForTest.class;
        synchronized (WebserverForTest.class) {
            WebserverForTest.class.wait();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public WebserverForTest(Module platformOverrides, Module appOverrides, VirtualFile metaFile, String ... args) {
        this(new TestConfig(platformOverrides, appOverrides, metaFile, true), args);
    }

    public WebserverForTest(TestConfig testConfig, String ... args) {
        Arguments cmdLineArgs = new CommandLineParser().parse(args);
        String filePath = System.getProperty("user.dir");
        log.info("property user.dir=" + filePath);
        VirtualFile metaFile = testConfig.getMetaFile();
        if (testConfig.getMetaFile() == null) {
            metaFile = new VirtualFileClasspath("basicMeta.txt", WebserverForTest.class.getClassLoader());
        }
        Module platformOverrides = testConfig.getPlatformOverrides();
        File baseWorkingDir = FileFactory.getBaseWorkingDir();
        WebServerConfig config = new WebServerConfig().setPlatformOverrides(platformOverrides);
        RouterConfig routerConfig = new RouterConfig(baseWorkingDir).setMetaFile(metaFile).setWebappOverrides(testConfig.getAppOverrides()).setFileEncoding(CHAR_SET_TO_USE).setDefaultResponseBodyEncoding(CHAR_SET_TO_USE).setCachedCompressedDirectory(this.cacheDir).setSecretKey(SecretKeyInfo.generateForTest()).setTokenCheckOn(testConfig.isUseTokenCheck());
        TemplateConfig templateConfig = new TemplateConfig();
        this.webServer = WebServerFactory.create((WebServerConfig)config, (RouterConfig)routerConfig, (TemplateConfig)templateConfig, (Arguments)cmdLineArgs);
        cmdLineArgs.checkConsumedCorrectly();
    }

    public void configure(ServerSocketChannel channel) throws SocketException {
        channel.socket().setReuseAddress(true);
    }

    public void start() {
        this.webServer.startSync();
    }

    public void stop() {
        this.webServer.stop();
    }

    public TCPServerChannel getUnderlyingHttpChannel() {
        return this.webServer.getUnderlyingHttpChannel();
    }

    public TCPServerChannel getUnderlyingHttpsChannel() {
        return this.webServer.getUnderlyingHttpsChannel();
    }

    public File getCacheDir() {
        return this.cacheDir;
    }
}

