/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.api.dto;

import com.webpieces.http2parser.api.Http2SettingsMap;
import com.webpieces.http2parser.api.dto.Http2Frame;
import com.webpieces.http2parser.api.dto.Http2FrameType;

public class Http2Settings
extends Http2Frame {
    private boolean ack = false;
    private Http2SettingsMap settings = new Http2SettingsMap();

    @Override
    public Http2FrameType getFrameType() {
        return Http2FrameType.SETTINGS;
    }

    public boolean isAck() {
        return this.ack;
    }

    public void setAck(boolean ack) {
        this.ack = ack;
        if (ack) {
            this.settings.clear();
        }
    }

    public void setSetting(Parameter param, Long value) {
        this.settings.put(param, value);
    }

    public void setSettings(Http2SettingsMap settings) {
        this.settings = settings;
    }

    public Http2SettingsMap getSettings() {
        if (!this.ack) {
            return this.settings;
        }
        return new Http2SettingsMap();
    }

    @Override
    public String toString() {
        return "Http2Settings{ack=" + this.ack + ", settings=" + this.settings + "} " + super.toString();
    }

    public static enum Parameter {
        SETTINGS_HEADER_TABLE_SIZE(1),
        SETTINGS_ENABLE_PUSH(2),
        SETTINGS_MAX_CONCURRENT_STREAMS(3),
        SETTINGS_INITIAL_WINDOW_SIZE(4),
        SETTINGS_MAX_FRAME_SIZE(5),
        SETTINGS_MAX_HEADER_LIST_SIZE(6);

        private short id;

        private Parameter(int id) {
            this.id = (short)id;
        }

        public short getId() {
            return this.id;
        }

        public static Parameter fromId(short id) {
            switch (id) {
                case 1: {
                    return SETTINGS_HEADER_TABLE_SIZE;
                }
                case 2: {
                    return SETTINGS_ENABLE_PUSH;
                }
                case 3: {
                    return SETTINGS_MAX_CONCURRENT_STREAMS;
                }
                case 4: {
                    return SETTINGS_INITIAL_WINDOW_SIZE;
                }
                case 5: {
                    return SETTINGS_MAX_FRAME_SIZE;
                }
                case 6: {
                    return SETTINGS_MAX_HEADER_LIST_SIZE;
                }
            }
            return SETTINGS_HEADER_TABLE_SIZE;
        }
    }
}

