/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.webpieces.http2parser.api.dto.Http2ErrorCode;
import com.webpieces.http2parser.api.dto.Http2Frame;
import com.webpieces.http2parser.api.dto.Http2GoAway;
import com.webpieces.http2parser.impl.FrameMarshallerImpl;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class GoAwayMarshaller
extends FrameMarshallerImpl {
    GoAwayMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool, dataGen);
    }

    @Override
    public byte marshalFlags(Http2Frame frame) {
        return 0;
    }

    @Override
    public DataWrapper marshalPayload(Http2Frame frame) {
        Http2GoAway castFrame = (Http2GoAway)frame;
        ByteBuffer prelude = this.bufferPool.nextBuffer(8);
        prelude.putInt(castFrame.getLastStreamId()).putInt(castFrame.getErrorCode().getCode());
        prelude.flip();
        return this.dataGen.chainDataWrappers(this.dataGen.wrapByteBuffer(prelude), castFrame.getDebugData());
    }

    @Override
    public void unmarshalFlagsAndPayload(Http2Frame frame, byte flagsByte, Optional<DataWrapper> maybePayload) {
        Http2GoAway castFrame = (Http2GoAway)frame;
        maybePayload.ifPresent(payload -> {
            List split = this.dataGen.split(payload, 8);
            ByteBuffer preludeBytes = this.bufferPool.createWithDataWrapper((DataWrapper)split.get(0));
            castFrame.setLastStreamId(preludeBytes.getInt());
            castFrame.setErrorCode(Http2ErrorCode.fromInteger(preludeBytes.getInt()));
            castFrame.setDebugData((DataWrapper)split.get(1));
            this.bufferPool.releaseBuffer(preludeBytes);
        });
    }
}

