/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.webpieces.http2parser.api.dto.Http2Frame;
import com.webpieces.http2parser.api.dto.Http2PushPromise;
import com.webpieces.http2parser.impl.FrameMarshallerImpl;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class PushPromiseMarshaller
extends FrameMarshallerImpl {
    PushPromiseMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool, dataGen);
    }

    @Override
    public DataWrapper marshalPayload(Http2Frame frame) {
        Http2PushPromise castFrame = (Http2PushPromise)frame;
        ByteBuffer prelude = this.bufferPool.nextBuffer(4);
        prelude.putInt(castFrame.getPromisedStreamId());
        prelude.flip();
        DataWrapper headersDW = castFrame.getHeaderFragment();
        DataWrapper finalDW = this.dataGen.chainDataWrappers(this.dataGen.wrapByteBuffer(prelude), headersDW);
        return castFrame.getPadding().padDataIfNeeded(finalDW);
    }

    @Override
    public byte marshalFlags(Http2Frame frame) {
        Http2PushPromise castFrame = (Http2PushPromise)frame;
        byte value = 0;
        if (castFrame.isEndHeaders()) {
            value = (byte)(value | 4);
        }
        if (castFrame.getPadding().isPadded()) {
            value = (byte)(value | 8);
        }
        return value;
    }

    @Override
    public void unmarshalFlagsAndPayload(Http2Frame frame, byte flags, Optional<DataWrapper> maybePayload) {
        Http2PushPromise castFrame = (Http2PushPromise)frame;
        castFrame.setEndHeaders((flags & 4) == 4);
        castFrame.getPadding().setIsPadded((flags & 8) == 8);
        maybePayload.ifPresent(payload -> {
            List split = this.dataGen.split(payload, 4);
            ByteBuffer prelude = this.bufferPool.createWithDataWrapper((DataWrapper)split.get(0));
            castFrame.setPromisedStreamId(prelude.getInt());
            castFrame.setHeaderFragment(castFrame.getPadding().extractPayloadAndSetPaddingIfNeeded((DataWrapper)split.get(1), frame.getStreamId()));
            this.bufferPool.releaseBuffer(prelude);
        });
    }
}

