/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl.marshallers;

import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.lib.AbstractHttp2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2Frame;
import com.webpieces.http2parser.impl.DataSplit;
import com.webpieces.http2parser.impl.Http2MementoImpl;
import com.webpieces.http2parser.impl.PaddingUtil;
import com.webpieces.http2parser.impl.marshallers.AbstractFrameMarshaller;
import com.webpieces.http2parser.impl.marshallers.FrameMarshaller;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class DataMarshaller
extends AbstractFrameMarshaller
implements FrameMarshaller {
    public DataMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool);
    }

    @Override
    public DataWrapper marshal(Http2Frame frame) {
        DataFrame castFrame = (DataFrame)frame;
        int paddingSize = castFrame.getPadding().getReadableSize();
        byte value = 0;
        if (castFrame.isEndOfStream()) {
            value = (byte)(value | 1);
        }
        if (paddingSize > 0) {
            value = (byte)(value | 8);
        }
        DataWrapper dataPayload = PaddingUtil.padDataIfNeeded(castFrame.getData(), castFrame.getPadding());
        return super.marshalFrame(frame, value, dataPayload);
    }

    @Override
    public AbstractHttp2Frame unmarshal(Http2MementoImpl state, DataWrapper framePayloadData) {
        DataFrame frame = new DataFrame();
        super.unmarshalFrame(state, frame);
        byte flags = state.getFrameHeaderData().getFlagsByte();
        frame.setEndOfStream((flags & 1) == 1);
        boolean isPadded = (flags & 8) == 8;
        DataSplit split = PaddingUtil.extractPayloadAndPadding(isPadded, framePayloadData, frame.getStreamId());
        frame.setData(split.getPayload());
        frame.setPadding(split.getPadding());
        return frame;
    }
}

