/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl.marshallers;

import com.webpieces.http2parser.api.Http2ParseException;
import com.webpieces.http2parser.api.dto.PingFrame;
import com.webpieces.http2parser.api.dto.lib.AbstractHttp2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2ErrorCode;
import com.webpieces.http2parser.api.dto.lib.Http2Frame;
import com.webpieces.http2parser.impl.FrameHeaderData;
import com.webpieces.http2parser.impl.Http2MementoImpl;
import com.webpieces.http2parser.impl.marshallers.AbstractFrameMarshaller;
import com.webpieces.http2parser.impl.marshallers.FrameMarshaller;
import java.nio.ByteBuffer;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class PingMarshaller
extends AbstractFrameMarshaller
implements FrameMarshaller {
    public PingMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool);
    }

    @Override
    public DataWrapper marshal(Http2Frame frame) {
        if (frame.getStreamId() != 0) {
            throw new IllegalArgumentException("PingFrame can never be any other stream id except 0 which is already set");
        }
        PingFrame ping = (PingFrame)frame;
        ByteBuffer payload = this.bufferPool.nextBuffer(8);
        payload.putLong(ping.getOpaqueData());
        payload.flip();
        DataWrapper dataPayload = dataGen.wrapByteBuffer(payload);
        byte value = 0;
        if (ping.isPingResponse()) {
            value = (byte)(value | 1);
        }
        return this.marshalFrame(frame, value, dataPayload);
    }

    @Override
    public AbstractHttp2Frame unmarshal(Http2MementoImpl state, DataWrapper framePayloadData) {
        FrameHeaderData frameHeaderData = state.getFrameHeaderData();
        int streamId = frameHeaderData.getStreamId();
        if (state.getFrameHeaderData().getPayloadLength() != 8) {
            throw new Http2ParseException(Http2ErrorCode.FRAME_SIZE_ERROR, streamId, true);
        }
        if (streamId != 0) {
            throw new Http2ParseException(Http2ErrorCode.PROTOCOL_ERROR, streamId, true);
        }
        PingFrame frame = new PingFrame();
        super.unmarshalFrame(state, frame);
        byte flags = state.getFrameHeaderData().getFlagsByte();
        frame.setIsPingResponse((flags & 1) == 1);
        ByteBuffer payloadByteBuffer = this.bufferPool.createWithDataWrapper(framePayloadData);
        frame.setOpaqueData(payloadByteBuffer.getLong());
        this.bufferPool.releaseBuffer(payloadByteBuffer);
        if (frame.getStreamId() != 0) {
            throw new IllegalArgumentException("PingFrame can never be any other stream id except 0 which is already set");
        }
        return frame;
    }
}

