/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl.marshallers;

import com.webpieces.http2parser.api.Http2ParseException;
import com.webpieces.http2parser.api.dto.SettingsFrame;
import com.webpieces.http2parser.api.dto.lib.AbstractHttp2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2ErrorCode;
import com.webpieces.http2parser.api.dto.lib.Http2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2Setting;
import com.webpieces.http2parser.api.dto.lib.SettingsParameter;
import com.webpieces.http2parser.impl.FrameHeaderData;
import com.webpieces.http2parser.impl.Http2MementoImpl;
import com.webpieces.http2parser.impl.UnsignedData;
import com.webpieces.http2parser.impl.marshallers.AbstractFrameMarshaller;
import com.webpieces.http2parser.impl.marshallers.FrameMarshaller;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class SettingsMarshaller
extends AbstractFrameMarshaller
implements FrameMarshaller {
    public SettingsMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool);
    }

    @Override
    public DataWrapper marshal(Http2Frame frame) {
        DataWrapper dataPayload;
        if (frame.getStreamId() != 0) {
            throw new IllegalArgumentException("SettingsFrame can never be any other stream id except 0 which is already set");
        }
        SettingsFrame castFrame = (SettingsFrame)frame;
        byte flags = 0;
        if (castFrame.isAck()) {
            flags = (byte)(flags | 1);
        }
        if (castFrame.isAck() || castFrame.getSettings().size() == 0) {
            dataPayload = dataGen.emptyWrapper();
        } else {
            List<Http2Setting> settings = castFrame.getSettings();
            dataPayload = this.marshalOut(settings);
        }
        return super.marshalFrame(frame, flags, dataPayload);
    }

    @Override
    public AbstractHttp2Frame unmarshal(Http2MementoImpl state, DataWrapper payload) {
        FrameHeaderData frameHeaderData = state.getFrameHeaderData();
        int payloadLength = frameHeaderData.getPayloadLength();
        int streamId = frameHeaderData.getStreamId();
        SettingsFrame frame = new SettingsFrame();
        super.unmarshalFrame(state, frame);
        byte flags = state.getFrameHeaderData().getFlagsByte();
        frame.setAck((flags & 1) == 1);
        if (frame.isAck()) {
            if (payloadLength != 0) {
                throw new Http2ParseException(Http2ErrorCode.FRAME_SIZE_ERROR, streamId, true);
            }
        } else {
            if (payloadLength % 6 != 0) {
                throw new Http2ParseException(Http2ErrorCode.FRAME_SIZE_ERROR, streamId, true);
            }
            if (streamId != 0) {
                throw new Http2ParseException(Http2ErrorCode.PROTOCOL_ERROR, streamId, true);
            }
        }
        ByteBuffer payloadByteBuffer = this.bufferPool.createWithDataWrapper(payload);
        List<Http2Setting> settingsList = this.unmarshal(payloadByteBuffer);
        frame.setSettings(settingsList);
        this.bufferPool.releaseBuffer(payloadByteBuffer);
        if (frame.getStreamId() != 0) {
            throw new IllegalArgumentException("SettingsFrame can never be any other stream id except 0 which is already set");
        }
        return frame;
    }

    private List<Http2Setting> unmarshal(ByteBuffer payloadByteBuffer) {
        ArrayList<Http2Setting> settings = new ArrayList<Http2Setting>();
        while (payloadByteBuffer.hasRemaining()) {
            int id = UnsignedData.getUnsignedShort(payloadByteBuffer);
            long value = UnsignedData.getUnsignedInt(payloadByteBuffer);
            SettingsParameter key = SettingsParameter.lookup(id);
            settings.add(new Http2Setting(id, value));
            this.validate(key, value);
        }
        return settings;
    }

    private void validate(SettingsParameter key, long value) {
        if (key == null) {
            return;
        }
        switch (key) {
            case SETTINGS_ENABLE_PUSH: {
                if (value == 0L || value == 1L) break;
                throw new Http2ParseException(Http2ErrorCode.PROTOCOL_ERROR);
            }
            case SETTINGS_INITIAL_WINDOW_SIZE: {
                this.validateWindowSize(value);
                break;
            }
            case SETTINGS_MAX_FRAME_SIZE: {
                this.validateMaxFrameSize(value);
                break;
            }
            case SETTINGS_HEADER_TABLE_SIZE: 
            case SETTINGS_MAX_CONCURRENT_STREAMS: 
            case SETTINGS_MAX_HEADER_LIST_SIZE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("case statement missing new setting=" + (Object)((Object)key) + " with value=" + value);
            }
        }
    }

    private void validateWindowSize(long value) {
        int min = 0;
        int max = Integer.MAX_VALUE;
        if (value < (long)min || value > (long)max) {
            throw new Http2ParseException(Http2ErrorCode.FLOW_CONTROL_ERROR);
        }
    }

    private void validateMaxFrameSize(long value) {
        int min = 16384;
        int max = 1677215;
        if (value < (long)min || value > (long)max) {
            throw new Http2ParseException(Http2ErrorCode.PROTOCOL_ERROR);
        }
    }

    public List<Http2Setting> unmarshalPayload(String base64SettingsPayload) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decoded = decoder.decode(base64SettingsPayload);
        ByteBuffer buf = ByteBuffer.wrap(decoded);
        return this.unmarshal(buf);
    }

    public String marshalPayload(List<Http2Setting> settingsPayload) {
        DataWrapper data = this.marshalOut(settingsPayload);
        byte[] byteBuf = data.createByteArray();
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(byteBuf);
    }

    private DataWrapper marshalOut(List<Http2Setting> settings) {
        ByteBuffer payload = this.bufferPool.nextBuffer(6 * settings.size());
        for (Http2Setting setting : settings) {
            UnsignedData.putUnsignedShort(payload, setting.getId());
            UnsignedData.putUnsignedInt(payload, setting.getValue());
        }
        payload.flip();
        DataWrapper dataPayload = dataGen.wrapByteBuffer(payload);
        return dataPayload;
    }
}

