/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.api.dto.error;

import com.webpieces.http2parser.api.dto.error.CancelReasonCode;
import com.webpieces.http2parser.api.dto.error.ErrorType;
import java.util.concurrent.CompletionException;

public abstract class Http2Exception
extends CompletionException {
    private static final long serialVersionUID = -2704718008204232741L;
    private int streamId = 0;
    private CancelReasonCode reason;

    public Http2Exception(CancelReasonCode reason, String logId, int streamId, String msg) {
        super(logId + ":stream" + streamId + ":(" + (Object)((Object)reason) + ") " + msg);
        this.reason = reason;
        this.streamId = streamId;
    }

    public Http2Exception(CancelReasonCode reason, String logId, int streamId, String msg, Throwable e) {
        super(logId + ":stream" + streamId + ":(" + (Object)((Object)reason) + ") " + msg, e);
        this.reason = reason;
        this.streamId = streamId;
    }

    public Http2Exception(CancelReasonCode reason, int streamId, String msg) {
        super("stream" + streamId + ":(" + (Object)((Object)reason) + ") " + msg);
        this.reason = reason;
        this.streamId = streamId;
    }

    public Http2Exception(CancelReasonCode reason, int streamId, String msg, Throwable e) {
        super(streamId + ":(" + (Object)((Object)reason) + ") " + msg, e);
        this.reason = reason;
        this.streamId = streamId;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public boolean hasStream() {
        return this.streamId == 0;
    }

    public CancelReasonCode getReason() {
        return this.reason;
    }

    public abstract ErrorType getErrorType();
}

