/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.NillableOrExpressionParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ListAttributeDefinition
extends AttributeDefinition {
    private final ParameterValidator elementValidator;

    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator) {
        this(name, name, allowNull, false, 0, Integer.MAX_VALUE, elementValidator, (String[])null, (String[])null, (AttributeMarshaller)null, false, (DeprecationData)null, (AccessConstraintDefinition[])null, (Boolean)null, (AttributeParser)null, (AttributeAccess.Flag[])null);
    }

    public ListAttributeDefinition(String name, boolean allowNull, ParameterValidator elementValidator, AttributeAccess.Flag ... flags) {
        this(name, name, allowNull, false, 0, Integer.MAX_VALUE, elementValidator, (String[])null, (String[])null, (AttributeMarshaller)null, false, (DeprecationData)null, (AccessConstraintDefinition[])null, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    public ListAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator) {
        this(name, xmlName, allowNull, false, minSize, maxSize, elementValidator, null, null, null, false, null, null, null, (AttributeParser)null, new AttributeAccess.Flag[0]);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, false, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, (AccessConstraintDefinition[])null, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, false, minSize, maxSize, elementValidator, alternatives, requires, (AttributeMarshaller)null, false, (DeprecationData)null, (AccessConstraintDefinition[])null, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, (AccessConstraintDefinition[])null, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, (AttributeMarshaller)null, false, (DeprecationData)null, (AccessConstraintDefinition[])null, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, false, (DeprecationData)null, accessConstraints, (Boolean)null, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean niSignificant, AttributeAccess.Flag ... flags) {
        this(name, xmlName, allowNull, allowExpressions, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, niSignificant, (AttributeParser)null, flags);
    }

    @Deprecated
    protected ListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean niSignificant, AttributeParser parser, AttributeAccess.Flag ... flags) {
        super(name, xmlName, null, ModelType.LIST, allowNull, allowExpressions, null, null, (ParameterValidator)new ListValidator(elementValidator, allowNull, minSize, maxSize), allowNull, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, niSignificant, parser, flags);
        this.elementValidator = elementValidator;
    }

    protected ListAttributeDefinition(Builder<?, ?> builder) {
        super(builder);
        this.elementValidator = builder.getElementValidator();
    }

    public ParameterValidator getElementValidator() {
        return this.elementValidator;
    }

    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        try {
            return this.parse(value);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
    }

    public void parseAndAddParameterElement(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, reader);
        operation.get(this.getName()).add(paramVal);
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, bundle2);
        return result;
    }

    protected abstract void addValueTypeDescription(ModelNode var1, ResourceBundle var2);

    protected abstract void addAttributeValueTypeDescription(ModelNode var1, ResourceDescriptionResolver var2, Locale var3, ResourceBundle var4);

    protected abstract void addOperationParameterValueTypeDescription(ModelNode var1, String var2, ResourceDescriptionResolver var3, Locale var4, ResourceBundle var5);

    private ModelNode parse(String value) throws OperationFailedException {
        ModelNode node;
        String trimmed;
        String string = trimmed = value == null ? null : value.trim();
        if (trimmed != null) {
            node = this.isAllowExpression() ? ParseUtils.parsePossibleExpression(trimmed) : new ModelNode().set(trimmed);
            if (node.getType() != ModelType.EXPRESSION) {
                switch (this.getType()) {
                    case BIG_DECIMAL: {
                        node.set(node.asBigDecimal());
                        break;
                    }
                    case BIG_INTEGER: {
                        node.set(node.asBigInteger());
                        break;
                    }
                    case BOOLEAN: {
                        node.set(node.asBoolean());
                        break;
                    }
                    case BYTES: {
                        node.set(node.asBytes());
                        break;
                    }
                    case DOUBLE: {
                        node.set(node.asDouble());
                        break;
                    }
                    case INT: {
                        node.set(node.asInt());
                        break;
                    }
                    case LONG: {
                        node.set(node.asLong());
                    }
                }
            }
        } else {
            node = new ModelNode();
        }
        this.elementValidator.validateParameter(this.getXmlName(), node);
        return node;
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        this.attributeMarshaller.marshallAsElement(this, resourceModel, marshallDefault, writer);
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        ModelNode result = parameter;
        if (parameter.isDefined()) {
            boolean changeMade = false;
            ModelNode newList = new ModelNode().setEmptyList();
            for (ModelNode item : parameter.asList()) {
                ModelNode converted = this.convertParameterElementExpressions(item);
                newList.add(converted);
                changeMade |= !converted.equals(item);
            }
            if (changeMade) {
                result = newList;
            }
        }
        return result;
    }

    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        return this.isAllowExpression() ? ListAttributeDefinition.convertStringExpression(parameterElement) : parameterElement;
    }

    public static abstract class Builder<BUILDER extends Builder, ATTRIBUTE extends ListAttributeDefinition>
    extends AbstractAttributeDefinitionBuilder<BUILDER, ATTRIBUTE> {
        private ParameterValidator elementValidator;
        private Boolean allowNullElement;

        protected Builder(String attributeName) {
            super(attributeName, ModelType.LIST);
        }

        protected Builder(String attributeName, boolean allowNull) {
            super(attributeName, ModelType.LIST, allowNull);
        }

        public Builder(ListAttributeDefinition basis) {
            super(basis);
            this.elementValidator = basis.getElementValidator();
        }

        public ParameterValidator getElementValidator() {
            if (this.elementValidator == null) {
                return null;
            }
            ParameterValidator toWrap = this.elementValidator;
            NillableOrExpressionParameterValidator wrappedElementValidator = null;
            if (this.elementValidator instanceof NillableOrExpressionParameterValidator) {
                NillableOrExpressionParameterValidator wrapped = (NillableOrExpressionParameterValidator)this.elementValidator;
                Boolean allow = wrapped.getAllowNull();
                if ((allow == null || allow != false) == this.getAllowNullElement() && wrapped.isAllowExpression() == this.isAllowExpression()) {
                    wrappedElementValidator = wrapped;
                } else {
                    toWrap = wrapped.getDelegate();
                }
            }
            if (wrappedElementValidator == null) {
                this.elementValidator = new NillableOrExpressionParameterValidator(toWrap, this.getAllowNullElement(), this.isAllowExpression());
            }
            return this.elementValidator;
        }

        public final BUILDER setElementValidator(ParameterValidator elementValidator) {
            if (elementValidator == null) {
                throw ControllerMessages.MESSAGES.nullVar("elementValidator");
            }
            this.elementValidator = elementValidator;
            this.validator = null;
            return (BUILDER)this;
        }

        @Override
        public BUILDER setValidator(ParameterValidator validator) {
            return this.setElementValidator(validator);
        }

        public BUILDER setListValidator(ParameterValidator validator) {
            return (BUILDER)((Builder)super.setValidator(validator));
        }

        @Override
        public int getMinSize() {
            if (this.minSize < 0) {
                this.minSize = 0;
            }
            return this.minSize;
        }

        @Override
        public int getMaxSize() {
            if (this.maxSize < 1) {
                this.maxSize = Integer.MAX_VALUE;
            }
            return this.maxSize;
        }

        public boolean getAllowNullElement() {
            return this.allowNullElement == null ? this.isAllowNull() : this.allowNullElement.booleanValue();
        }

        public BUILDER setAllowNullElement(boolean allowNullElement) {
            this.allowNullElement = allowNullElement;
            return (BUILDER)this;
        }

        @Override
        public ParameterValidator getValidator() {
            ParameterValidator result = super.getValidator();
            if (result == null) {
                ParameterValidator listElementValidator = this.getElementValidator();
                assert (listElementValidator != null);
                result = new ListValidator(this.getElementValidator(), this.isAllowNull(), this.getMinSize(), this.getMaxSize());
            }
            return result;
        }
    }
}

