/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import org.jboss.as.server.deployment.module.ResourceRoot;

public final class ManifestExtensionListProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List<ResourceRoot> resourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        for (ResourceRoot resourceRoot : resourceRoots) {
            Attributes mainAttributes;
            String extensionListString;
            Manifest manifest = resourceRoot.getAttachment(Attachments.MANIFEST);
            if (manifest == null || (extensionListString = (mainAttributes = manifest.getMainAttributes()).getValue(Attributes.Name.EXTENSION_LIST)) == null) continue;
            String[] items = extensionListString.split("\\s+");
            boolean added = false;
            for (String item : items) {
                String extensionName = mainAttributes.getValue(item + "-" + Attributes.Name.EXTENSION_NAME);
                if (extensionName == null) {
                    ServerLogger.DEPLOYMENT_LOGGER.extensionMissingManifestAttribute(item, item, Attributes.Name.EXTENSION_NAME);
                    continue;
                }
                String specificationVersion = mainAttributes.getValue(item + "-" + Attributes.Name.SPECIFICATION_VERSION);
                String implementationVersion = mainAttributes.getValue(item + "-" + Attributes.Name.IMPLEMENTATION_VERSION);
                String implementationVendorId = mainAttributes.getValue(item + "-" + Attributes.Name.IMPLEMENTATION_VENDOR_ID);
                String implementationUrl = mainAttributes.getValue(item + "-" + Attributes.Name.IMPLEMENTATION_URL);
                URI implementationUri = null;
                if (implementationUrl == null) {
                    ServerLogger.DEPLOYMENT_LOGGER.debugf("Extension %s is missing the required manifest attribute %s-%s", item, item, Attributes.Name.IMPLEMENTATION_URL);
                } else {
                    try {
                        implementationUri = new URI(implementationUrl);
                    }
                    catch (URISyntaxException e) {
                        ServerLogger.DEPLOYMENT_LOGGER.invalidExtensionURI(item, e);
                    }
                }
                resourceRoot.addToAttachmentList(Attachments.EXTENSION_LIST_ENTRIES, new ExtensionListEntry(item, extensionName, specificationVersion, implementationVersion, implementationVendorId, implementationUri));
                added = true;
            }
            if (!added) continue;
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

