/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.xipki.security.SignerConf;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

class InternUtil {
    private InternUtil() {
    }

    static String formatCert(X509Certificate cert, boolean verbose) {
        if (cert == null) {
            return "  null";
        }
        StringBuilder sb = new StringBuilder(verbose ? 1000 : 100);
        sb.append("  issuer: ").append(X509Util.getRfc4519Name((X500Principal)cert.getIssuerX500Principal())).append('\n');
        sb.append("  serialNumber: ").append(LogUtil.formatCsn((BigInteger)cert.getSerialNumber())).append('\n');
        sb.append("  subject: ").append(X509Util.getRfc4519Name((X500Principal)cert.getSubjectX500Principal())).append('\n');
        sb.append("  notBefore: ").append(cert.getNotBefore()).append("\n");
        sb.append("  notAfter: ").append(cert.getNotAfter());
        if (verbose) {
            sb.append("\n  encoded: ");
            try {
                sb.append(Base64.encodeToString((byte[])cert.getEncoded()));
            }
            catch (CertificateEncodingException ex) {
                sb.append("ERROR");
            }
        }
        return sb.toString();
    }

    static String signerConfToString(String signerConf, boolean verbose, boolean ignoreSensitiveInfo) {
        ParamUtil.requireNonBlank((String)"signerConf", (String)signerConf);
        if (ignoreSensitiveInfo) {
            signerConf = SignerConf.eraseSensitiveData((String)signerConf);
        }
        if (verbose || signerConf.length() < 101) {
            return signerConf;
        }
        return StringUtil.concat((String)signerConf.substring(0, 97), (String[])new String[]{"..."});
    }
}

