/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import org.xipki.ca.api.NameId;
import org.xipki.ca.server.mgmt.api.CaMgmtException;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class UserEntry {
    private final NameId ident;
    private final boolean active;
    private final String hashedPassword;

    public UserEntry(NameId ident, boolean active, String hashedPassword) throws CaMgmtException {
        this.ident = (NameId)ParamUtil.requireNonNull((String)"ident", (Object)ident);
        this.active = active;
        this.hashedPassword = ParamUtil.requireNonBlank((String)"hashedPassword", (String)hashedPassword);
    }

    public NameId getIdent() {
        return this.ident;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public int hashCode() {
        return this.ident.hashCode() + 31 + this.hashedPassword.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserEntry)) {
            return false;
        }
        return this.equals((UserEntry)obj, false);
    }

    public boolean equals(UserEntry obj, boolean ignoreId) {
        if (!this.ident.equals(obj.ident, ignoreId)) {
            return false;
        }
        return this.hashedPassword.equals(obj.hashedPassword);
    }

    public String toString() {
        return StringUtil.concatObjectsCap((int)200, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nactive: ", this.active, "\npassword: *****\n"});
    }
}

