/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.spring.web.advice.AdviceTrait;
import org.zalando.problem.spring.web.advice.validation.ConstraintViolationProblem;
import org.zalando.problem.spring.web.advice.validation.Violation;

interface BaseValidationAdviceTrait
extends AdviceTrait {
    default public URI defaultConstraintViolationType() {
        return ConstraintViolationProblem.TYPE;
    }

    default public StatusType defaultConstraintViolationStatus() {
        return Status.BAD_REQUEST;
    }

    default public String formatFieldName(String fieldName) {
        return fieldName;
    }

    default public ResponseEntity<Problem> newConstraintViolationProblem(Throwable throwable, Collection<Violation> stream, NativeWebRequest request) {
        URI type = this.defaultConstraintViolationType();
        StatusType status = this.defaultConstraintViolationStatus();
        List<Violation> violations = stream.stream().sorted(Comparator.comparing(Violation::getField).thenComparing(Violation::getMessage)).collect(Collectors.toList());
        ConstraintViolationProblem problem = new ConstraintViolationProblem(type, status, violations);
        return this.create(throwable, (Problem)problem, request);
    }
}

