/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.zaproxy.clientapi.core.Alert;

public class AlertsFile {
    public static void saveAlertsToFile(List<Alert> requireAlerts, List<Alert> reportAlerts, List<Alert> ignoredAlerts, File outputFile) throws JDOMException, IOException {
        Element alerts = new Element("alerts");
        Document alertsDocument = new Document(alerts);
        alertsDocument.setRootElement(alerts);
        if (reportAlerts.size() > 0) {
            Element alertsFound = new Element("alertsFound");
            alertsFound.setAttribute("alertsFound", Integer.toString(reportAlerts.size()));
            for (Alert alert : reportAlerts) {
                AlertsFile.createAlertXMLElements(alertsFound, alert);
            }
            alertsDocument.getRootElement().addContent((Content)alertsFound);
        }
        if (requireAlerts.size() > 0) {
            Element alertsNotFound = new Element("alertsNotFound");
            alertsNotFound.setAttribute("alertsNotFound", Integer.toString(requireAlerts.size()));
            for (Alert alert : requireAlerts) {
                AlertsFile.createAlertXMLElements(alertsNotFound, alert);
            }
            alertsDocument.getRootElement().addContent((Content)alertsNotFound);
        }
        if (ignoredAlerts.size() > 0) {
            Element ignoredAlertsFound = new Element("ignoredAlertsFound");
            ignoredAlertsFound.setAttribute("ignoredAlertsFound", Integer.toString(ignoredAlerts.size()));
            for (Alert alert : ignoredAlerts) {
                AlertsFile.createAlertXMLElements(ignoredAlertsFound, alert);
            }
            alertsDocument.getRootElement().addContent((Content)ignoredAlertsFound);
        }
        AlertsFile.writeAlertsToFile(outputFile, alertsDocument);
    }

    private static void writeAlertsToFile(File outputFile, Document doc) {
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        try {
            xmlOutput.output(doc, (Writer)new FileWriter(outputFile));
            System.out.println("alert xml report saved to: " + outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createAlertXMLElements(Element alertsFound, Alert alert) {
        Element alertElement = new Element("alert");
        if (alert.getName() != null) {
            alertElement.setAttribute("name", alert.getName());
            alertElement.setAttribute("alert", alert.getName());
        }
        if (alert.getRisk() != null) {
            alertElement.setAttribute("risk", alert.getRisk().name());
        }
        if (alert.getUrl() != null) {
            alertElement.setAttribute("confidence", alert.getConfidence().name());
        }
        if (alert.getUrl() != null) {
            alertElement.setAttribute("url", alert.getUrl());
        }
        if (alert.getParam() != null) {
            alertElement.setAttribute("param", alert.getParam());
        }
        if (alert.getOther() != null) {
            alertElement.setAttribute("other", alert.getOther());
        }
        if (alert.getAttack() != null) {
            alertElement.setAttribute("attack", alert.getAttack());
        }
        if (alert.getDescription() != null) {
            alertElement.setAttribute("description", alert.getDescription());
        }
        if (alert.getSolution() != null) {
            alertElement.setAttribute("solution", alert.getSolution());
        }
        if (alert.getReference() != null) {
            alertElement.setAttribute("reference", alert.getReference());
        }
        alertsFound.addContent((Content)alertElement);
    }

    public static List<Alert> getAlertsFromFile(File file, String alertType) throws JDOMException, IOException {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        SAXBuilder parser = new SAXBuilder();
        Document alertsDoc = parser.build(file);
        List alertElements = alertsDoc.getRootElement().getChildren(alertType);
        for (Element element : alertElements) {
            String name = element.getAttributeValue("name");
            if (name == null) {
                name = element.getAttributeValue("alert");
            }
            Alert alert = new Alert(name, element.getAttributeValue("url"), element.getAttributeValue("risk"), element.getAttributeValue("confidence"), element.getAttributeValue("param"), element.getAttributeValue("other"));
            alerts.add(alert);
        }
        return alerts;
    }
}

