/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph;

import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.fix.completable.reactor.graph.TransitionBuilder;
import ru.fix.completable.reactor.graph.internal.GlEmptyMerger;
import ru.fix.completable.reactor.graph.internal.GlTransition;
import ru.fix.completable.reactor.graph.internal.GlTransitionBuilder;
import ru.fix.completable.reactor.graph.runtime.GlVertex;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/fix/completable/reactor/graph/Vertex;", "", "()V", "vx", "Lru/fix/completable/reactor/graph/runtime/GlVertex;", "addEmptyMergerIfNotExists", "", "checkForIncompatibleTransitions", "newTransition", "Lru/fix/completable/reactor/graph/internal/GlTransition;", "on", "Lru/fix/completable/reactor/graph/TransitionBuilder;", "mergeStatus", "", "onAny", "onElse", "completable-reactor-graph"})
public final class Vertex {
    private GlVertex vx = new GlVertex(this);

    @NotNull
    public final TransitionBuilder on(@NotNull Enum<?> mergeStatus) {
        Intrinsics.checkParameterIsNotNull(mergeStatus, (String)"mergeStatus");
        if (this.vx.merger == null && this.vx.router == null) {
            throw (Throwable)new IllegalArgumentException("" + "Vertex " + this.vx.name + " is used as source of on() transition but does not have merger or router.");
        }
        if (this.vx.merger != null && !this.vx.isRoutable) {
            throw (Throwable)new IllegalArgumentException("" + "Vertex " + this.vx.name + " have non routable merger or implicit non routable empty merger." + " That vertex could participate only in .onAny() transition.");
        }
        if (this.vx.router != null && !this.vx.isRoutable) {
            throw (Throwable)new IllegalArgumentException("" + "Vertex " + this.vx.name + " have non routable mutator." + " That vertex could participate only in .onAny() transition.");
        }
        GlTransition transition = new GlTransition(null, false, false, false, null, null, 63, null);
        transition.setMergeStatuses(SetsKt.hashSetOf((Object[])new Enum[]{mergeStatus}));
        return new GlTransitionBuilder(this, transition, this.vx.transitions);
    }

    @NotNull
    public final TransitionBuilder onAny() {
        this.addEmptyMergerIfNotExists();
        GlTransition transition = new GlTransition(null, false, false, false, null, null, 63, null);
        transition.setOnAny(true);
        this.checkForIncompatibleTransitions(transition);
        return new GlTransitionBuilder(this, transition, this.vx.transitions);
    }

    @NotNull
    public final TransitionBuilder onElse() {
        GlTransition transition = new GlTransition(null, false, false, false, null, null, 63, null);
        transition.setOnElse(true);
        this.checkForIncompatibleTransitions(transition);
        return new GlTransitionBuilder(this, transition, this.vx.transitions);
    }

    private final void addEmptyMergerIfNotExists() {
        if ((this.vx.handler != null || this.vx.subgraphPayloadBuilder != null) && this.vx.merger == null) {
            this.vx.merger = new GlEmptyMerger();
        }
    }

    private final void checkForIncompatibleTransitions(GlTransition newTransition) {
        if (this.vx.merger == null && this.vx.router == null) {
            String name = newTransition.isOnAny() ? "onAny()" : "onElse()";
            throw (Throwable)new IllegalArgumentException("" + "Vertex " + this.vx.name + " is used as source of " + name + " transition but does not have merger or router.");
        }
        boolean hasIncompatibleTransition = false;
        Iterable $receiver$iv = this.vx.transitions;
        for (Object element$iv : $receiver$iv) {
            GlTransition transition = (GlTransition)element$iv;
            if (transition.isOnAny() && newTransition.isOnElse()) {
                hasIncompatibleTransition = true;
                continue;
            }
            if (!transition.isOnElse() || !newTransition.isOnAny()) continue;
            hasIncompatibleTransition = true;
        }
        if (hasIncompatibleTransition) {
            throw (Throwable)new IllegalArgumentException("Vertex " + this.vx.name + " is used together incompatible transitions onElse and onAny.");
        }
    }
}

