/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.concurrency.threads;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import ru.fix.aggregating.profiler.ProfiledCall;
import ru.fix.aggregating.profiler.Profiler;
import ru.fix.dynamic.property.api.DynamicProperty;

public class ProfiledScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final long THREAD_IDLE_TIMEOUT_BEFORE_TERMINATION_SEC = 60L;
    final Profiler profiler;
    final ThreadLocal<ProfiledCall> runExecution = new ThreadLocal();
    private final String poolName;
    private final String queueIndicatorName;
    private final String activeThreadsIndicatorName;
    private final String callRunName;
    private final String poolSizeIndicatorName;

    private static ThreadFactory threadFactory(String poolName) {
        AtomicInteger counter = new AtomicInteger();
        return runnable -> new Thread(runnable, poolName + "-" + counter.getAndIncrement());
    }

    public ProfiledScheduledThreadPoolExecutor(String poolName, DynamicProperty<Integer> maxPoolSize, Profiler profiler) {
        super((int)((Integer)maxPoolSize.get()), ProfiledScheduledThreadPoolExecutor.threadFactory(poolName));
        this.profiler = profiler;
        this.poolName = poolName;
        String profilerPoolName = poolName.replace('.', '_');
        this.queueIndicatorName = "pool." + profilerPoolName + ".queue";
        this.activeThreadsIndicatorName = "pool." + profilerPoolName + ".activeThreads";
        this.callRunName = "pool." + profilerPoolName + ".run";
        this.poolSizeIndicatorName = "pool." + profilerPoolName + ".poolSize";
        this.setRemoveOnCancelPolicy(true);
        this.setKeepAliveTime(60L, TimeUnit.SECONDS);
        this.allowCoreThreadTimeOut(true);
        maxPoolSize.addAndCallListener((oldVal, newVal) -> this.setMaxPoolSize((int)newVal));
        profiler.attachIndicator(this.queueIndicatorName, () -> this.getQueue().size());
        profiler.attachIndicator(this.activeThreadsIndicatorName, () -> this.getActiveCount());
        profiler.attachIndicator(this.poolSizeIndicatorName, () -> this.getPoolSize());
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.runExecution.set(this.profiler.profiledCall(this.callRunName).start());
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ProfiledCall runCall = this.runExecution.get();
        if (runCall != null) {
            runCall.stop();
            this.runExecution.remove();
        }
        super.afterExecute(r, t);
    }

    @Override
    protected void terminated() {
        this.profiler.detachIndicator(this.queueIndicatorName);
        this.profiler.detachIndicator(this.activeThreadsIndicatorName);
        this.profiler.detachIndicator(this.poolSizeIndicatorName);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize >= this.getMaximumPoolSize()) {
            this.setMaximumPoolSize(maxPoolSize);
            this.setCorePoolSize(maxPoolSize);
        } else {
            this.setCorePoolSize(maxPoolSize);
            this.setMaximumPoolSize(maxPoolSize);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.poolName + ")";
    }
}

