/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.concurrency.threads;

import java.util.Objects;
import ru.fix.dynamic.property.api.DynamicProperty;

public class Schedule {
    private final Type type;
    private final long value;

    public Schedule(Type type, long value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        return this.value == schedule.value && this.type == schedule.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public static Schedule withRate(long rate) {
        return new Schedule(Type.RATE, rate);
    }

    public static DynamicProperty<Schedule> withRate(DynamicProperty<? extends Number> rate) {
        return rate.map(newValue -> new Schedule(Type.RATE, newValue.longValue()));
    }

    public static Schedule withDelay(long delay) {
        return new Schedule(Type.DELAY, delay);
    }

    public static DynamicProperty<Schedule> withDelay(DynamicProperty<? extends Number> delay) {
        return delay.map(newValue -> new Schedule(Type.DELAY, newValue.longValue()));
    }

    public static enum Type {
        DELAY,
        RATE;

    }
}

