/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericDeclarationScope;
import ru.vyarus.java.generics.resolver.context.container.ExplicitTypeVariable;
import ru.vyarus.java.generics.resolver.context.container.GenericArrayTypeImpl;
import ru.vyarus.java.generics.resolver.context.container.ParameterizedTypeImpl;
import ru.vyarus.java.generics.resolver.context.container.WildcardTypeImpl;
import ru.vyarus.java.generics.resolver.error.UnknownGenericException;
import ru.vyarus.java.generics.resolver.util.GenericsResolutionUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;

public final class GenericsUtils {
    private static final Type[] NO_TYPES = new Type[0];

    private GenericsUtils() {
    }

    public static Class<?> getReturnClass(Method method, Map<String, Type> generics) {
        Type returnType = method.getGenericReturnType();
        return GenericsUtils.resolveClass(returnType, generics);
    }

    public static Type[] getGenerics(Type type, Map<String, Type> generics) {
        Class actual;
        Type[] res = NO_TYPES;
        Type analyzingType = type;
        if (type instanceof TypeVariable) {
            analyzingType = GenericsUtils.declaredGeneric((TypeVariable)type, generics);
        }
        if (analyzingType instanceof ParameterizedType && ((ParameterizedType)analyzingType).getActualTypeArguments().length > 0) {
            res = ((ParameterizedType)analyzingType).getActualTypeArguments();
        } else if (type instanceof Class && (actual = (Class)analyzingType).getTypeParameters().length > 0) {
            res = GenericsResolutionUtils.resolveDirectRawGenerics(actual).values().toArray(new Type[0]);
        }
        return res;
    }

    public static List<Class<?>> resolveGenericsOf(Type type, Map<String, Type> generics) {
        Type[] typeGenerics = GenericsUtils.getGenerics(type, generics);
        if (typeGenerics.length == 0) {
            return Collections.emptyList();
        }
        ArrayList res = new ArrayList();
        for (Type gen : typeGenerics) {
            res.add(GenericsUtils.resolveClass(gen, generics));
        }
        return res;
    }

    public static Class<?> resolveClass(Type type, Map<String, Type> generics) {
        Class<?> res;
        if (type instanceof Class) {
            res = (Class<?>)type;
        } else if (type instanceof ExplicitTypeVariable) {
            res = GenericsUtils.resolveClass(((ExplicitTypeVariable)type).getBounds()[0], generics);
        } else if (type instanceof ParameterizedType) {
            res = GenericsUtils.resolveClass(((ParameterizedType)type).getRawType(), generics);
        } else if (type instanceof TypeVariable) {
            res = GenericsUtils.resolveClass(GenericsUtils.declaredGeneric((TypeVariable)type, generics), generics);
        } else if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            res = GenericsUtils.resolveClass(upperBounds[0], generics);
        } else {
            Class<?> arrayType = GenericsUtils.resolveClass(((GenericArrayType)type).getGenericComponentType(), generics);
            try {
                res = arrayType.isArray() ? Class.forName("[" + arrayType.getName()) : Class.forName("[L" + arrayType.getName() + ";");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to create array class for " + arrayType.getSimpleName(), e);
            }
        }
        return res;
    }

    public static List<Class<?>> resolveClasses(Type[] types, Map<String, Type> generics) {
        ArrayList params = new ArrayList();
        for (Type type : types) {
            params.add(GenericsUtils.resolveClass(type, generics));
        }
        return params;
    }

    public static Class[] resolveUpperBounds(Type type, Map<String, Type> generics) {
        Class[] res;
        if (type instanceof WildcardType) {
            ArrayList list = new ArrayList();
            for (Type t : ((WildcardType)type).getUpperBounds()) {
                Class<?> bound = GenericsUtils.resolveClass(t, generics);
                if (bound == Object.class) continue;
                list.add(bound);
            }
            if (list.isEmpty()) {
                list.add(Object.class);
            }
            res = list.toArray(new Class[0]);
        } else {
            res = new Class[]{TypeUtils.wrapPrimitive(GenericsUtils.resolveClass(type, generics))};
        }
        return res;
    }

    public static Type resolveTypeVariables(Type type, Map<String, Type> generics) {
        Object resolvedGenericType = null;
        if (type instanceof TypeVariable) {
            resolvedGenericType = GenericsUtils.declaredGeneric((TypeVariable)type, generics);
        } else if (type instanceof ExplicitTypeVariable) {
            resolvedGenericType = type;
        } else if (type instanceof Class) {
            resolvedGenericType = type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)type;
            resolvedGenericType = new ParameterizedTypeImpl(parametrizedType.getRawType(), GenericsUtils.resolveTypeVariables(parametrizedType.getActualTypeArguments(), generics), parametrizedType.getOwnerType());
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            resolvedGenericType = new GenericArrayTypeImpl(GenericsUtils.resolveTypeVariables(arrayType.getGenericComponentType(), generics));
        } else if (type instanceof WildcardType) {
            Type[] upperBounds;
            Type lowerBound;
            WildcardType wildcard = (WildcardType)type;
            resolvedGenericType = wildcard.getLowerBounds().length > 0 ? ((lowerBound = GenericsUtils.resolveTypeVariables(wildcard.getLowerBounds(), generics)[0]) == Object.class ? Object.class : WildcardTypeImpl.lower(lowerBound)) : ((upperBounds = GenericsUtils.resolveTypeVariables(wildcard.getUpperBounds(), generics)).length == 1 ? upperBounds[0] : WildcardTypeImpl.upper(upperBounds));
        }
        return resolvedGenericType;
    }

    public static Type[] resolveTypeVariables(Type[] types, Map<String, Type> generics) {
        if (types.length == 0) {
            return NO_TYPES;
        }
        Type[] resolved = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = GenericsUtils.resolveTypeVariables(types[i], generics);
        }
        return resolved;
    }

    public static Map<String, Type> extractOwnerGenerics(Class<?> type, Map<String, Type> generics) {
        boolean hasOwnerGenerics;
        boolean bl = hasOwnerGenerics = type.isMemberClass() && type.getTypeParameters().length != generics.size();
        if (!hasOwnerGenerics) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Type> res = new LinkedHashMap<String, Type>(generics);
        for (TypeVariable<Class<?>> var : type.getTypeParameters()) {
            res.remove(var.getName());
        }
        return res;
    }

    public static Map<String, Type> extractTypeGenerics(Class<?> type, Map<String, Type> generics) {
        boolean enoughGenerics;
        boolean bl = enoughGenerics = type.getTypeParameters().length == generics.size();
        if (enoughGenerics) {
            return generics;
        }
        LinkedHashMap<String, Type> res = new LinkedHashMap<String, Type>();
        for (TypeVariable<Class<?>> var : type.getTypeParameters()) {
            String name = var.getName();
            if (generics.containsKey(name)) {
                res.put(name, generics.get(name));
                continue;
            }
            res.put(name, GenericsUtils.resolveClass(var.getBounds()[0], res));
        }
        return res;
    }

    public static Class<?> getDeclarationClass(TypeVariable variable) {
        return GenericsUtils.getDeclarationClass(variable.getGenericDeclaration());
    }

    public static Class<?> getDeclarationClass(GenericDeclaration source) {
        Class<Object> res = null;
        if (source != null) {
            if (source instanceof Class) {
                res = (Class<?>)source;
            } else if (source instanceof Method) {
                res = ((Method)source).getDeclaringClass();
            } else if (source instanceof Constructor) {
                res = ((Constructor)source).getDeclaringClass();
            }
        }
        return res;
    }

    public static LinkedHashMap<String, Type> createGenericsMap(Class<?> type, List<? extends Type> generics) {
        TypeVariable<Class<?>>[] params = type.getTypeParameters();
        if (params.length != generics.size()) {
            throw new IllegalArgumentException(String.format("Can't build generics map for %s with %s because of incorrect generics count", type.getSimpleName(), Arrays.toString(generics.toArray())));
        }
        LinkedHashMap<String, Type> res = new LinkedHashMap<String, Type>();
        int i = 0;
        for (TypeVariable<Class<?>> var : params) {
            res.put(var.getName(), generics.get(i++));
        }
        return GenericsResolutionUtils.fillOuterGenerics(type, res, null);
    }

    public static TypeVariable findIncompatibleVariable(Type type, Class<?> context, GenericDeclarationScope contextScope, GenericDeclaration contextSource) {
        TypeVariable res = null;
        for (TypeVariable var : GenericsUtils.findVariables(type)) {
            Class<?> target = GenericsUtils.getDeclarationClass(var);
            if (!target.equals(context) && !target.equals(TypeUtils.getOuter(context))) {
                res = var;
                break;
            }
            if (contextScope.isCompatible(GenericDeclarationScope.from(var.getGenericDeclaration())) && contextSource == var.getGenericDeclaration()) continue;
            res = var;
            break;
        }
        return res;
    }

    public static List<TypeVariable> orderVariablesForResolution(List<TypeVariable> variables) {
        ArrayList<TypeVariable> vars = new ArrayList<TypeVariable>(variables);
        ArrayList<String> countableNames = new ArrayList<String>();
        for (TypeVariable var : variables) {
            countableNames.add(var.getName());
        }
        ArrayList<String> known = new ArrayList<String>();
        ArrayList<TypeVariable> res = new ArrayList<TypeVariable>();
        while (!vars.isEmpty()) {
            Iterator it = vars.iterator();
            while (it.hasNext()) {
                TypeVariable var = (TypeVariable)it.next();
                boolean reject = false;
                block3: for (Type bound : var.getBounds()) {
                    List<TypeVariable> unknowns = GenericsUtils.findVariables(bound);
                    for (TypeVariable unknown : unknowns) {
                        if (!countableNames.contains(unknown.getName()) || known.contains(unknown.getName())) continue;
                        reject = true;
                        continue block3;
                    }
                }
                if (reject) continue;
                res.add(var);
                known.add(var.getName());
                it.remove();
            }
        }
        return res;
    }

    public static List<TypeVariable> findVariables(Type type) {
        if (type instanceof Class) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariable> res = new ArrayList<TypeVariable>();
        GenericsUtils.findVariables(type, res);
        return res;
    }

    private static void findVariables(Type type, List<TypeVariable> found) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(type instanceof TypeVariable)) break block5;
                        found.add((TypeVariable)type);
                        break block6;
                    }
                    if (!(type instanceof ParameterizedType)) break block7;
                    ParameterizedType parametrizedType = (ParameterizedType)type;
                    if (parametrizedType.getOwnerType() != null) {
                        GenericsUtils.findVariables(parametrizedType.getOwnerType(), found);
                    }
                    for (Type par : parametrizedType.getActualTypeArguments()) {
                        GenericsUtils.findVariables(par, found);
                    }
                    break block6;
                }
                if (!(type instanceof GenericArrayType)) break block8;
                GenericsUtils.findVariables(((GenericArrayType)type).getGenericComponentType(), found);
                break block6;
            }
            if (!(type instanceof WildcardType)) break block6;
            WildcardType wildcard = (WildcardType)type;
            if (wildcard.getLowerBounds().length > 0) {
                GenericsUtils.findVariables(wildcard.getLowerBounds()[0], found);
            } else {
                for (Type par : wildcard.getUpperBounds()) {
                    GenericsUtils.findVariables(par, found);
                }
            }
        }
    }

    private static Type declaredGeneric(TypeVariable generic, Map<String, Type> declarations) {
        String name = generic.getName();
        Type result = declarations.get(name);
        if (result == null) {
            throw new UnknownGenericException(name, (GenericDeclaration)generic.getGenericDeclaration());
        }
        return result;
    }
}

