/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.map.IgnoreGenericsMap;
import ru.vyarus.java.generics.resolver.util.walk.AssignabilityTypesVisitor;
import ru.vyarus.java.generics.resolver.util.walk.ComparatorTypesVisitor;
import ru.vyarus.java.generics.resolver.util.walk.CompatibilityTypesVisitor;
import ru.vyarus.java.generics.resolver.util.walk.TypesWalker;

public final class TypeUtils {
    private static final Map<String, Type> IGNORE_VARS = IgnoreGenericsMap.getInstance();
    private static final Map<Class, Class> PRIMITIVES = new HashMap<Class, Class>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Double.TYPE, Double.class);
            this.put(Float.TYPE, Float.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Short.TYPE, Short.class);
            this.put(Void.TYPE, Void.class);
        }
    };

    private TypeUtils() {
    }

    public static Class<?> wrapPrimitive(Class<?> type) {
        return type.isPrimitive() ? PRIMITIVES.get(type) : type;
    }

    public static boolean isMoreSpecific(Type what, Type comparingTo) {
        ComparatorTypesVisitor visitor = new ComparatorTypesVisitor();
        TypesWalker.walk(what, comparingTo, visitor);
        if (!visitor.isCompatible()) {
            throw new IllegalArgumentException(String.format("Type %s can't be compared to %s because they are not compatible", TypeToStringUtils.toStringType(what, IGNORE_VARS), TypeToStringUtils.toStringType(comparingTo, IGNORE_VARS)));
        }
        return visitor.isMoreSpecific();
    }

    public static boolean isAssignable(Type what, Type toType) {
        AssignabilityTypesVisitor visitor = new AssignabilityTypesVisitor();
        TypesWalker.walk(what, toType, visitor);
        return visitor.isAssignable();
    }

    public static boolean isAssignableBounds(Class[] one, Class[] two) {
        if (one.length == 0 || two.length == 0) {
            throw new IllegalArgumentException(String.format("Incomplete bounds information: %s %s", Arrays.toString(one), Arrays.toString(two)));
        }
        for (Class oneType : one) {
            boolean assignable = true;
            for (Class twoType : two) {
                if (oneType == Object.class || twoType == Object.class || twoType.isAssignableFrom(oneType)) continue;
                assignable = false;
                break;
            }
            if (!assignable) continue;
            return true;
        }
        return false;
    }

    public static Type getMoreSpecificType(Type one, Type two) {
        return TypeUtils.isMoreSpecific(one, two) ? one : two;
    }

    public static boolean isCompatible(Type one, Type two) {
        CompatibilityTypesVisitor visitor = new CompatibilityTypesVisitor();
        TypesWalker.walk(one, two, visitor);
        return visitor.isCompatible();
    }

    public static boolean isInner(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getOwnerType() != null;
        }
        Class<?> actual = GenericsUtils.resolveClass(type, IGNORE_VARS);
        return !actual.isInterface() && actual.isMemberClass() && !Modifier.isStatic(actual.getModifiers());
    }

    public static Type getOuter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getOwnerType();
        }
        return TypeUtils.isInner(type) ? GenericsUtils.resolveClass(type, IGNORE_VARS).getEnclosingClass() : null;
    }
}

