/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information required for custom authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomAuthConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomAuthConfig.Builder, CustomAuthConfig> {
    private static final SdkField<String> CUSTOM_AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customAuthenticationType").getter(getter(CustomAuthConfig::customAuthenticationType))
            .setter(setter(Builder::customAuthenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAuthenticationType").build())
            .build();

    private static final SdkField<List<AuthParameter>> AUTH_PARAMETERS_FIELD = SdkField
            .<List<AuthParameter>> builder(MarshallingType.LIST)
            .memberName("authParameters")
            .getter(getter(CustomAuthConfig::authParameters))
            .setter(setter(Builder::authParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_AUTHENTICATION_TYPE_FIELD, AUTH_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customAuthenticationType;

    private final List<AuthParameter> authParameters;

    private CustomAuthConfig(BuilderImpl builder) {
        this.customAuthenticationType = builder.customAuthenticationType;
        this.authParameters = builder.authParameters;
    }

    /**
     * <p>
     * The authentication type that the custom connector uses.
     * </p>
     * 
     * @return The authentication type that the custom connector uses.
     */
    public final String customAuthenticationType() {
        return customAuthenticationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthParameters() {
        return authParameters != null && !(authParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about authentication parameters required for authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthParameters} method.
     * </p>
     * 
     * @return Information about authentication parameters required for authentication.
     */
    public final List<AuthParameter> authParameters() {
        return authParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customAuthenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthParameters() ? authParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAuthConfig)) {
            return false;
        }
        CustomAuthConfig other = (CustomAuthConfig) obj;
        return Objects.equals(customAuthenticationType(), other.customAuthenticationType())
                && hasAuthParameters() == other.hasAuthParameters() && Objects.equals(authParameters(), other.authParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomAuthConfig").add("CustomAuthenticationType", customAuthenticationType())
                .add("AuthParameters", hasAuthParameters() ? authParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customAuthenticationType":
            return Optional.ofNullable(clazz.cast(customAuthenticationType()));
        case "authParameters":
            return Optional.ofNullable(clazz.cast(authParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomAuthConfig, T> g) {
        return obj -> g.apply((CustomAuthConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomAuthConfig> {
        /**
         * <p>
         * The authentication type that the custom connector uses.
         * </p>
         * 
         * @param customAuthenticationType
         *        The authentication type that the custom connector uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAuthenticationType(String customAuthenticationType);

        /**
         * <p>
         * Information about authentication parameters required for authentication.
         * </p>
         * 
         * @param authParameters
         *        Information about authentication parameters required for authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authParameters(Collection<AuthParameter> authParameters);

        /**
         * <p>
         * Information about authentication parameters required for authentication.
         * </p>
         * 
         * @param authParameters
         *        Information about authentication parameters required for authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authParameters(AuthParameter... authParameters);

        /**
         * <p>
         * Information about authentication parameters required for authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.AuthParameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appflow.model.AuthParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.AuthParameter.Builder#build()} is called immediately and
         * its result is passed to {@link #authParameters(List<AuthParameter>)}.
         * 
         * @param authParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.AuthParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authParameters(java.util.Collection<AuthParameter>)
         */
        Builder authParameters(Consumer<AuthParameter.Builder>... authParameters);
    }

    static final class BuilderImpl implements Builder {
        private String customAuthenticationType;

        private List<AuthParameter> authParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAuthConfig model) {
            customAuthenticationType(model.customAuthenticationType);
            authParameters(model.authParameters);
        }

        public final String getCustomAuthenticationType() {
            return customAuthenticationType;
        }

        public final void setCustomAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
        }

        @Override
        public final Builder customAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
            return this;
        }

        public final List<AuthParameter.Builder> getAuthParameters() {
            List<AuthParameter.Builder> result = AuthParameterListCopier.copyToBuilder(this.authParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthParameters(Collection<AuthParameter.BuilderImpl> authParameters) {
            this.authParameters = AuthParameterListCopier.copyFromBuilder(authParameters);
        }

        @Override
        public final Builder authParameters(Collection<AuthParameter> authParameters) {
            this.authParameters = AuthParameterListCopier.copy(authParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authParameters(AuthParameter... authParameters) {
            authParameters(Arrays.asList(authParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authParameters(Consumer<AuthParameter.Builder>... authParameters) {
            authParameters(Stream.of(authParameters).map(c -> AuthParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomAuthConfig build() {
            return new CustomAuthConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
