/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorProfilesRequest extends AppflowRequest implements
        ToCopyableBuilder<DescribeConnectorProfilesRequest.Builder, DescribeConnectorProfilesRequest> {
    private static final SdkField<List<String>> CONNECTOR_PROFILE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("connectorProfileNames")
            .getter(getter(DescribeConnectorProfilesRequest::connectorProfileNames))
            .setter(setter(Builder::connectorProfileNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(DescribeConnectorProfilesRequest::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorLabel").getter(getter(DescribeConnectorProfilesRequest::connectorLabel))
            .setter(setter(Builder::connectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeConnectorProfilesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeConnectorProfilesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAMES_FIELD,
            CONNECTOR_TYPE_FIELD, CONNECTOR_LABEL_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> connectorProfileNames;

    private final String connectorType;

    private final String connectorLabel;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeConnectorProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileNames = builder.connectorProfileNames;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorProfileNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorProfileNames() {
        return connectorProfileNames != null && !(connectorProfileNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon Web
     * Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorProfileNames} method.
     * </p>
     * 
     * @return The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
     *         Amazon Web Services account.
     */
    public final List<String> connectorProfileNames() {
        return connectorProfileNames;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web
     * Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
     * </p>
     * 
     * @return The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon
     *         Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
     */
    public final String connectorLabel() {
        return connectorLabel;
    }

    /**
     * <p>
     * Specifies the maximum number of items that should be returned in the result set. The default for
     * <code>maxResults</code> is 20 (for all paginated API operations).
     * </p>
     * 
     * @return Specifies the maximum number of items that should be returned in the result set. The default for
     *         <code>maxResults</code> is 20 (for all paginated API operations).
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token for the next page of data.
     * </p>
     * 
     * @return The pagination token for the next page of data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorProfileNames() ? connectorProfileNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorProfilesRequest)) {
            return false;
        }
        DescribeConnectorProfilesRequest other = (DescribeConnectorProfilesRequest) obj;
        return hasConnectorProfileNames() == other.hasConnectorProfileNames()
                && Objects.equals(connectorProfileNames(), other.connectorProfileNames())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorLabel(), other.connectorLabel()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorProfilesRequest")
                .add("ConnectorProfileNames", hasConnectorProfileNames() ? connectorProfileNames() : null)
                .add("ConnectorType", connectorTypeAsString()).add("ConnectorLabel", connectorLabel())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileNames":
            return Optional.ofNullable(clazz.cast(connectorProfileNames()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorLabel":
            return Optional.ofNullable(clazz.cast(connectorLabel()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorProfilesRequest, T> g) {
        return obj -> g.apply((DescribeConnectorProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorProfilesRequest> {
        /**
         * <p>
         * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon
         * Web Services account.
         * </p>
         * 
         * @param connectorProfileNames
         *        The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileNames(Collection<String> connectorProfileNames);

        /**
         * <p>
         * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the Amazon
         * Web Services account.
         * </p>
         * 
         * @param connectorProfileNames
         *        The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in the
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileNames(String... connectorProfileNames);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your Amazon Web
         * Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
         * </p>
         * 
         * @param connectorLabel
         *        The name of the connector. The name is unique for each <code>ConnectorRegistration</code> in your
         *        Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorLabel(String connectorLabel);

        /**
         * <p>
         * Specifies the maximum number of items that should be returned in the result set. The default for
         * <code>maxResults</code> is 20 (for all paginated API operations).
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of items that should be returned in the result set. The default for
         *        <code>maxResults</code> is 20 (for all paginated API operations).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token for the next page of data.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the next page of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private List<String> connectorProfileNames = DefaultSdkAutoConstructList.getInstance();

        private String connectorType;

        private String connectorLabel;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorProfilesRequest model) {
            super(model);
            connectorProfileNames(model.connectorProfileNames);
            connectorType(model.connectorType);
            connectorLabel(model.connectorLabel);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getConnectorProfileNames() {
            if (connectorProfileNames instanceof SdkAutoConstructList) {
                return null;
            }
            return connectorProfileNames;
        }

        public final void setConnectorProfileNames(Collection<String> connectorProfileNames) {
            this.connectorProfileNames = ConnectorProfileNameListCopier.copy(connectorProfileNames);
        }

        @Override
        public final Builder connectorProfileNames(Collection<String> connectorProfileNames) {
            this.connectorProfileNames = ConnectorProfileNameListCopier.copy(connectorProfileNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorProfileNames(String... connectorProfileNames) {
            connectorProfileNames(Arrays.asList(connectorProfileNames));
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorProfilesRequest build() {
            return new DescribeConnectorProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
